/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.common.providers.math;

import com.blackgear.platform.common.providers.math.IntProvider;
import com.blackgear.platform.common.providers.math.IntProviderType;
import com.blackgear.platform.core.util.MathUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.util.math.MathHelper;

public class ClampedNormalInt
extends IntProvider {
    public static final Codec<ClampedNormalInt> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("mean").forGetter(provider -> Float.valueOf(provider.mean)), (App)Codec.FLOAT.fieldOf("deviation").forGetter(provider -> Float.valueOf(provider.deviation)), (App)Codec.INT.fieldOf("min_inclusive").forGetter(provider -> provider.minInclusive), (App)Codec.INT.fieldOf("max_inclusive").forGetter(provider -> provider.maxInclusive)).apply((Applicative)instance, ClampedNormalInt::new)).comapFlatMap(provider -> {
        if (provider.maxInclusive < provider.minInclusive) {
            return DataResult.error((String)("Max must be larger than min: [" + provider.minInclusive + ", " + provider.maxInclusive + "]"));
        }
        return DataResult.success((Object)provider);
    }, Function.identity());
    private final float mean;
    private final float deviation;
    private final int minInclusive;
    private final int maxInclusive;

    public static ClampedNormalInt of(float mean, float deviation, int minInclusive, int maxInclusive) {
        return new ClampedNormalInt(mean, deviation, minInclusive, maxInclusive);
    }

    public ClampedNormalInt(float mean, float deviation, int minInclusive, int maxInclusive) {
        this.mean = mean;
        this.deviation = deviation;
        this.minInclusive = minInclusive;
        this.maxInclusive = maxInclusive;
    }

    @Override
    public int sample(Random random) {
        return ClampedNormalInt.sample(random, this.mean, this.deviation, this.minInclusive, this.maxInclusive);
    }

    public static int sample(Random random, float mean, float deviation, float minInclusive, float maxInclusive) {
        return (int)MathHelper.func_76131_a((float)MathUtils.normal(random, mean, deviation), (float)minInclusive, (float)maxInclusive);
    }

    @Override
    public int getMinValue() {
        return this.minInclusive;
    }

    @Override
    public int getMaxValue() {
        return this.maxInclusive;
    }

    @Override
    public IntProviderType<?> getType() {
        return IntProviderType.CLAMPED_NORMAL;
    }

    public String toString() {
        return "normal(" + this.mean + ", " + this.deviation + ") in [" + this.minInclusive + "-" + this.maxInclusive + "]";
    }
}

