/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.common.providers.math;

import com.blackgear.platform.common.providers.math.FloatProvider;
import com.blackgear.platform.common.providers.math.FloatProviderType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;

public class ConstantFloat
extends FloatProvider {
    public static final Codec<ConstantFloat> CODEC = Codec.either((Codec)Codec.FLOAT, (Codec)RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("value").forGetter(provider -> Float.valueOf(provider.value))).apply((Applicative)instance, ConstantFloat::new))).xmap(either -> (ConstantFloat)either.map(ConstantFloat::of, provider -> provider), provider -> Either.left((Object)Float.valueOf(provider.value)));
    public static final ConstantFloat ZERO = new ConstantFloat(0.0f);
    private final float value;

    public static ConstantFloat of(float value) {
        return value == 0.0f ? ZERO : new ConstantFloat(value);
    }

    public ConstantFloat(float value) {
        this.value = value;
    }

    public float getValue() {
        return this.value;
    }

    @Override
    public float sample(Random random) {
        return this.value;
    }

    @Override
    public float getMinValue() {
        return this.value;
    }

    @Override
    public float getMaxValue() {
        return this.value + 1.0f;
    }

    @Override
    public FloatProviderType<?> getType() {
        return FloatProviderType.CONSTANT;
    }

    public String toString() {
        return Float.toString(this.value);
    }
}

