/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.common.providers.math;

import com.blackgear.platform.common.providers.math.ConstantFloat;
import com.blackgear.platform.common.providers.math.FloatProviderType;
import com.blackgear.platform.core.registry.PlatformRegistries;
import com.blackgear.platform.core.util.ExtraCodecs;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Random;

public abstract class FloatProvider {
    private static final Codec<Either<Float, FloatProvider>> CONSTANT_OR_DISPATCH_CODEC = Codec.either((Codec)Codec.FLOAT, (Codec)PlatformRegistries.FLOAT_PROVIDER_TYPE.getRegistry().dispatch(FloatProvider::getType, FloatProviderType::codec));
    public static final Codec<FloatProvider> CODEC = CONSTANT_OR_DISPATCH_CODEC.xmap(either -> (FloatProvider)either.map(ConstantFloat::of, provider -> provider), provider -> provider.getType() == FloatProviderType.CONSTANT ? Either.left((Object)Float.valueOf(((ConstantFloat)provider).getValue())) : Either.right((Object)provider));

    public static Codec<FloatProvider> createCodec(float minValue, float maxValue) {
        return FloatProvider.createCodec(minValue, maxValue, CODEC);
    }

    private static <T extends FloatProvider> Codec<T> createCodec(float minValue, float maxValue, Codec<T> codec) {
        return ExtraCodecs.validate(codec, provider -> {
            if (provider.getMinValue() < minValue) {
                return DataResult.error((String)("Value provider too low: " + minValue + " [" + provider.getMinValue() + "-" + provider.getMaxValue() + "]"));
            }
            return provider.getMaxValue() > maxValue ? DataResult.error((String)("Value provider too high: " + maxValue + " [" + provider.getMinValue() + "-" + provider.getMaxValue() + "]")) : DataResult.success((Object)provider);
        });
    }

    public abstract float sample(Random var1);

    public abstract float getMinValue();

    public abstract float getMaxValue();

    public abstract FloatProviderType<?> getType();
}

