/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.common.providers.math;

import com.blackgear.platform.common.providers.math.ConstantInt;
import com.blackgear.platform.common.providers.math.IntProviderType;
import com.blackgear.platform.core.registry.PlatformRegistries;
import com.blackgear.platform.core.util.ExtraCodecs;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Random;

public abstract class IntProvider {
    private static final Codec<Either<Integer, IntProvider>> CONSTANT_OR_DISPATCH_CODEC = Codec.either((Codec)Codec.INT, (Codec)PlatformRegistries.INT_PROVIDER_TYPE.getRegistry().dispatch(IntProvider::getType, IntProviderType::codec));
    public static final Codec<IntProvider> CODEC = CONSTANT_OR_DISPATCH_CODEC.xmap(either -> (IntProvider)either.map(ConstantInt::of, provider -> provider), provider -> provider.getType() == IntProviderType.CONSTANT ? Either.left((Object)((ConstantInt)provider).getValue()) : Either.right((Object)provider));
    public static final Codec<IntProvider> NON_NEGATIVE_CODEC = IntProvider.createCodec(0, Integer.MAX_VALUE);
    public static final Codec<IntProvider> POSITIVE_CODEC = IntProvider.createCodec(1, Integer.MAX_VALUE);

    public static Codec<IntProvider> createCodec(int minValue, int maxValue) {
        return IntProvider.createCodec(minValue, maxValue, CODEC);
    }

    private static <T extends IntProvider> Codec<T> createCodec(int minValue, int maxValue, Codec<T> codec) {
        return ExtraCodecs.validate(codec, provider -> {
            if (provider.getMinValue() < minValue) {
                return DataResult.error((String)("Value provider too low: " + minValue + " [" + provider.getMinValue() + "-" + provider.getMaxValue() + "]"));
            }
            return provider.getMaxValue() > maxValue ? DataResult.error((String)("Value provider too high: " + maxValue + " [" + provider.getMinValue() + "-" + provider.getMaxValue() + "]")) : DataResult.success((Object)provider);
        });
    }

    public abstract int sample(Random var1);

    public abstract int getMinValue();

    public abstract int getMaxValue();

    public abstract IntProviderType<?> getType();
}

