/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.common.providers.math;

import com.blackgear.platform.common.providers.math.FloatProvider;
import com.blackgear.platform.common.providers.math.FloatProviderType;
import com.blackgear.platform.core.util.MathUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import java.util.function.Function;

public class UniformFloat
extends FloatProvider {
    public static final Codec<UniformFloat> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("min_inclusive").forGetter(provider -> Float.valueOf(provider.minInclusive)), (App)Codec.FLOAT.fieldOf("max_exclusive").forGetter(provider -> Float.valueOf(provider.maxExclusive))).apply((Applicative)instance, UniformFloat::new)).comapFlatMap(provider -> {
        if (provider.maxExclusive <= provider.minInclusive) {
            return DataResult.error((String)("Max must be at least min, min_inclusive: " + provider.minInclusive + ", max_inclusive: " + provider.maxExclusive));
        }
        return DataResult.success((Object)provider);
    }, Function.identity());
    private final float minInclusive;
    private final float maxExclusive;

    public UniformFloat(float minInclusive, float maxExclusive) {
        this.minInclusive = minInclusive;
        this.maxExclusive = maxExclusive;
    }

    public static UniformFloat of(float minInclusive, float maxExclusive) {
        if (maxExclusive <= minInclusive) {
            throw new IllegalArgumentException("Max must exceed min");
        }
        return new UniformFloat(minInclusive, maxExclusive);
    }

    @Override
    public float sample(Random random) {
        return MathUtils.randomBetween(random, this.minInclusive, this.maxExclusive);
    }

    @Override
    public float getMinValue() {
        return this.minInclusive;
    }

    @Override
    public float getMaxValue() {
        return this.maxExclusive;
    }

    @Override
    public FloatProviderType<?> getType() {
        return FloatProviderType.UNIFORM;
    }

    public String toString() {
        return "[" + this.minInclusive + "-" + this.maxExclusive + "]";
    }
}

