/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.common.worldgen;

import com.blackgear.platform.common.worldgen.forge.BiomeSpawnPlacementImpl;
import com.blackgear.platform.common.worldgen.parameters.Temperature;
import com.blackgear.platform.core.mixin.access.BiomesAccessor;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;

public class BiomeSpawnPlacement {
    private static final Map<RegistryKey<Biome>, RegistryKey<Biome>> OVERWORLD_BORDER_MAP = new HashMap<RegistryKey<Biome>, RegistryKey<Biome>>();
    private static final Map<RegistryKey<Biome>, List<PredicatedBiomeEntry>> PREDICATED_BORDER_MAP = new HashMap<RegistryKey<Biome>, List<PredicatedBiomeEntry>>();

    private static RegistryKey<Biome> sanitize(RegistryKey<Biome> biome) {
        int rawId = WorldGenRegistries.field_243657_i.func_148757_b((Object)((Biome)WorldGenRegistries.field_243657_i.func_230516_a_(biome)));
        BiomesAccessor.getTO_NAME().computeIfAbsent(rawId, key -> biome);
        return biome;
    }

    public static void addBorderBiome(RegistryKey<Biome> biome, RegistryKey<Biome> border) {
        OVERWORLD_BORDER_MAP.put(BiomeSpawnPlacement.sanitize(biome), BiomeSpawnPlacement.sanitize(border));
    }

    public static Optional<RegistryKey<Biome>> getBorder(RegistryKey<Biome> biome) {
        return Optional.ofNullable(OVERWORLD_BORDER_MAP.get(biome));
    }

    public static List<PredicatedBiomeEntry> getPredicatedBorders(RegistryKey<Biome> biome) {
        return PREDICATED_BORDER_MAP.getOrDefault(biome, new ArrayList());
    }

    public static void addPredicatedBorderBiome(RegistryKey<Biome> biomeBase, RegistryKey<Biome> biomeBorder, Predicate<RegistryKey<Biome>> predicate) {
        PREDICATED_BORDER_MAP.computeIfAbsent(BiomeSpawnPlacement.sanitize(biomeBase), biome -> new ArrayList()).add(new PredicatedBiomeEntry(BiomeSpawnPlacement.sanitize(biomeBorder), predicate));
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void addContinentalBiome(RegistryKey<Biome> biome, Temperature temperature, double weight) {
        void var2_2;
        void var1_1;
        BiomeSpawnPlacementImpl.addContinentalBiome(biome, (Temperature)var1_1, (double)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void addHillsBiome(RegistryKey<Biome> parent, RegistryKey<Biome> hills, double weight) {
        void var2_2;
        void var1_1;
        BiomeSpawnPlacementImpl.addHillsBiome(parent, (RegistryKey<Biome>)var1_1, (double)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void addShoreBiome(RegistryKey<Biome> parent, RegistryKey<Biome> shore, double weight) {
        void var2_2;
        void var1_1;
        BiomeSpawnPlacementImpl.addShoreBiome(parent, (RegistryKey<Biome>)var1_1, (double)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void addEdgeBiome(RegistryKey<Biome> parent, RegistryKey<Biome> edge, double weight) {
        void var2_2;
        void var1_1;
        BiomeSpawnPlacementImpl.addEdgeBiome(parent, (RegistryKey<Biome>)var1_1, (double)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void addBiomeVariant(RegistryKey<Biome> replaced, RegistryKey<Biome> variant, double chance, Temperature ... temperatures) {
        void var4_3;
        void var2_2;
        void var1_1;
        BiomeSpawnPlacementImpl.addBiomeVariant(replaced, (RegistryKey<Biome>)var1_1, (double)var2_2, (Temperature[])var4_3);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void addRiverBiome(RegistryKey<Biome> parent, RegistryKey<Biome> river) {
        void var1_1;
        BiomeSpawnPlacementImpl.addRiverBiome(parent, (RegistryKey<Biome>)var1_1);
    }

    public static final class PredicatedBiomeEntry {
        public final RegistryKey<Biome> biome;
        public final Predicate<RegistryKey<Biome>> predicate;

        PredicatedBiomeEntry(RegistryKey<Biome> biome, Predicate<RegistryKey<Biome>> predicate) {
            this.biome = biome;
            this.predicate = predicate;
        }
    }
}

