/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.common.worldgen;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.IChunk;
import org.jetbrains.annotations.Nullable;

public final class BulkSectionAccess
implements AutoCloseable {
    private final IWorld level;
    private final Long2ObjectMap<ChunkSection> acquiredSections = new Long2ObjectOpenHashMap();
    @Nullable
    private ChunkSection lastSection;
    private long lastSectionKey;

    public BulkSectionAccess(IWorld level) {
        this.level = level;
    }

    @Nullable
    public ChunkSection getSection(BlockPos pos) {
        int sectionY = SectionPos.func_218159_a((int)pos.func_177956_o());
        if (this.isSectionIndexValid(sectionY)) {
            long sectionKey = SectionPos.func_218166_b((int)SectionPos.func_218159_a((int)pos.func_177958_n()), (int)sectionY, (int)SectionPos.func_218159_a((int)pos.func_177952_p()));
            if (this.lastSection == null || this.lastSectionKey != sectionKey) {
                this.lastSection = (ChunkSection)this.acquiredSections.computeIfAbsent(sectionKey, key -> {
                    IChunk chunk = this.level.func_212866_a_(SectionPos.func_218159_a((int)pos.func_177958_n()), SectionPos.func_218159_a((int)pos.func_177952_p()));
                    ChunkSection section = ((ChunkPrimer)chunk).func_217332_a(sectionY);
                    section.func_222635_a();
                    return section;
                });
                this.lastSectionKey = sectionKey;
            }
            return this.lastSection;
        }
        return Chunk.field_186036_a;
    }

    private boolean isSectionIndexValid(int sectionY) {
        return sectionY >= 0 && sectionY < SectionPos.func_218159_a((int)(this.level.func_217301_I() - 1)) + 1;
    }

    public BlockState getBlockState(BlockPos pos) {
        ChunkSection section = this.getSection(pos);
        if (section == null) {
            return Blocks.field_150350_a.func_176223_P();
        }
        int x = SectionPos.func_218171_b((int)pos.func_177958_n());
        int y = SectionPos.func_218171_b((int)pos.func_177956_o());
        int z = SectionPos.func_218171_b((int)pos.func_177952_p());
        return section.func_177485_a(x, y, z);
    }

    @Override
    public void close() {
        for (ChunkSection section : this.acquiredSections.values()) {
            section.func_222637_b();
        }
    }
}

