/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.common.worldgen;

import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;

public enum CaveSurface implements IStringSerializable
{
    CEILING(Direction.UP, 1, "ceiling"),
    FLOOR(Direction.DOWN, -1, "floor");

    public static final Codec<CaveSurface> CODEC;
    private static final Map<String, CaveSurface> BY_NAME;
    private final Direction direction;
    private final int y;
    private final String id;

    private CaveSurface(Direction direction, int y, String id) {
        this.direction = direction;
        this.y = y;
        this.id = id;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public int getY() {
        return this.y;
    }

    public String func_176610_l() {
        return this.id;
    }

    public String getName() {
        return this.id;
    }

    public static CaveSurface byName(String name) {
        return BY_NAME.get(name);
    }

    static {
        CODEC = IStringSerializable.func_233023_a_(CaveSurface::values, CaveSurface::byName);
        BY_NAME = Arrays.stream(CaveSurface.values()).collect(Collectors.toMap(CaveSurface::func_176610_l, surface -> surface));
    }
}

