/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.common.worldgen;

import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.gen.IWorldGenerationBaseReader;

public abstract class Column {
    public static Range around(int floor, int ceiling) {
        return new Range(floor - 1, ceiling + 1);
    }

    public static Range inside(int floor, int ceiling) {
        return new Range(floor, ceiling);
    }

    public static Column below(int ceiling) {
        return new Ray(ceiling, false);
    }

    public static Column fromHighest(int ceiling) {
        return new Ray(ceiling + 1, false);
    }

    public static Column above(int floor) {
        return new Ray(floor, true);
    }

    public static Column fromLowest(int floor) {
        return new Ray(floor - 1, true);
    }

    public static Column line() {
        return Line.INSTANCE;
    }

    public static Column create(OptionalInt floor, OptionalInt ceiling) {
        if (floor.isPresent() && ceiling.isPresent()) {
            return Column.inside(floor.getAsInt(), ceiling.getAsInt());
        }
        if (floor.isPresent()) {
            return Column.above(floor.getAsInt());
        }
        return ceiling.isPresent() ? Column.below(ceiling.getAsInt()) : Column.line();
    }

    public abstract OptionalInt getCeiling();

    public abstract OptionalInt getFloor();

    public abstract OptionalInt getHeight();

    public Column withFloor(OptionalInt floor) {
        return Column.create(floor, this.getCeiling());
    }

    public Column withCeiling(OptionalInt ceiling) {
        return Column.create(this.getFloor(), ceiling);
    }

    public static Optional<Column> scan(IWorldGenerationBaseReader level, BlockPos blockPos, int maxDistance, Predicate<BlockState> columnPredicate, Predicate<BlockState> tipPredicate) {
        BlockPos.Mutable mutableBlockPos = blockPos.func_239590_i_();
        if (!level.func_217375_a(blockPos, columnPredicate)) {
            return Optional.empty();
        }
        int y = blockPos.func_177956_o();
        OptionalInt optionalInt = Column.scanDirection(level, maxDistance, columnPredicate, tipPredicate, mutableBlockPos, y, Direction.UP);
        OptionalInt optionalInt2 = Column.scanDirection(level, maxDistance, columnPredicate, tipPredicate, mutableBlockPos, y, Direction.DOWN);
        return Optional.of(Column.create(optionalInt2, optionalInt));
    }

    private static OptionalInt scanDirection(IWorldGenerationBaseReader level, int maxDistance, Predicate<BlockState> columnPredicate, Predicate<BlockState> tipPredicate, BlockPos.Mutable mutable, int startY, Direction direction) {
        mutable.func_185336_p(startY);
        for (int i = 1; i < maxDistance && level.func_217375_a((BlockPos)mutable, columnPredicate); ++i) {
            mutable.func_189536_c(direction);
        }
        return level.func_217375_a((BlockPos)mutable, tipPredicate) ? OptionalInt.of(mutable.func_177956_o()) : OptionalInt.empty();
    }

    public static final class Range
    extends Column {
        private final int floor;
        private final int ceiling;

        private Range(int floor, int ceiling) {
            this.floor = floor;
            this.ceiling = ceiling;
            if (this.height() < 0) {
                throw new IllegalArgumentException("Column of negative height: " + this);
            }
        }

        @Override
        public OptionalInt getCeiling() {
            return OptionalInt.of(this.ceiling);
        }

        @Override
        public OptionalInt getFloor() {
            return OptionalInt.of(this.floor);
        }

        @Override
        public OptionalInt getHeight() {
            return OptionalInt.of(this.height());
        }

        public int ceiling() {
            return this.ceiling;
        }

        public int floor() {
            return this.floor;
        }

        public int height() {
            return this.ceiling - this.floor - 1;
        }

        public String toString() {
            return "C(" + this.ceiling + "-" + this.floor + ")";
        }
    }

    public static final class Ray
    extends Column {
        private final int edge;
        private final boolean pointingUp;

        public Ray(int edge, boolean pointingUp) {
            this.edge = edge;
            this.pointingUp = pointingUp;
        }

        @Override
        public OptionalInt getCeiling() {
            return this.pointingUp ? OptionalInt.empty() : OptionalInt.of(this.edge);
        }

        @Override
        public OptionalInt getFloor() {
            return this.pointingUp ? OptionalInt.of(this.edge) : OptionalInt.empty();
        }

        @Override
        public OptionalInt getHeight() {
            return OptionalInt.empty();
        }

        public String toString() {
            return this.pointingUp ? "C(" + this.edge + "-)" : "C(-" + this.edge + ")";
        }
    }

    public static final class Line
    extends Column {
        static final Line INSTANCE = new Line();

        @Override
        public OptionalInt getCeiling() {
            return OptionalInt.empty();
        }

        @Override
        public OptionalInt getFloor() {
            return OptionalInt.empty();
        }

        @Override
        public OptionalInt getHeight() {
            return OptionalInt.empty();
        }

        public String toString() {
            return "C(-)";
        }
    }
}

