/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.common.worldgen.biome;

import com.blackgear.platform.common.worldgen.biome.InternalBiomeUtils;
import com.blackgear.platform.common.worldgen.biome.VariantTransformer;
import com.blackgear.platform.common.worldgen.biome.WeightedBiomePicker;
import com.blackgear.platform.common.worldgen.parameters.Temperature;
import com.blackgear.platform.core.mixin.access.OverworldBiomeSourceAccessor;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.layer.LayerUtil;

public class InternalBiomeData {
    private static final EnumMap<Temperature, WeightedBiomePicker> OVERWORLD_MODDED_CONTINENTAL_BIOME_PICKERS = new EnumMap(Temperature.class);
    private static final Map<RegistryKey<Biome>, WeightedBiomePicker> OVERWORLD_HILLS_MAP = new IdentityHashMap<RegistryKey<Biome>, WeightedBiomePicker>();
    private static final Map<RegistryKey<Biome>, WeightedBiomePicker> OVERWORLD_SHORE_MAP = new IdentityHashMap<RegistryKey<Biome>, WeightedBiomePicker>();
    private static final Map<RegistryKey<Biome>, WeightedBiomePicker> OVERWORLD_EDGE_MAP = new IdentityHashMap<RegistryKey<Biome>, WeightedBiomePicker>();
    private static final Map<RegistryKey<Biome>, VariantTransformer> OVERWORLD_VARIANT_TRANSFORMERS = new IdentityHashMap<RegistryKey<Biome>, VariantTransformer>();
    private static final Map<RegistryKey<Biome>, RegistryKey<Biome>> OVERWORLD_RIVER_MAP = new IdentityHashMap<RegistryKey<Biome>, RegistryKey<Biome>>();

    public static void addOverworldContinentalBiome(Temperature climate, RegistryKey<Biome> biome, double weight) {
        Preconditions.checkArgument((climate != null ? 1 : 0) != 0, (Object)"Climate is null");
        Preconditions.checkArgument((biome != null ? 1 : 0) != 0, (Object)"Biome is null");
        Preconditions.checkArgument((!Double.isNaN(weight) ? 1 : 0) != 0, (Object)"Weight is NaN");
        Preconditions.checkArgument((weight > 0.0 ? 1 : 0) != 0, (String)"Weight is less than or equal to 0.0 (%s)", (Object)weight);
        InternalBiomeUtils.ensureIdMapping(biome);
        OVERWORLD_MODDED_CONTINENTAL_BIOME_PICKERS.computeIfAbsent(climate, k -> new WeightedBiomePicker()).addBiome(biome, weight);
        InternalBiomeData.injectOverworldBiome(biome);
    }

    public static void addOverworldHillsBiome(RegistryKey<Biome> primary, RegistryKey<Biome> hills, double weight) {
        Preconditions.checkArgument((primary != null ? 1 : 0) != 0, (Object)"Primary biome is null");
        Preconditions.checkArgument((hills != null ? 1 : 0) != 0, (Object)"Hills biome is null");
        Preconditions.checkArgument((!Double.isNaN(weight) ? 1 : 0) != 0, (Object)"Weight is NaN");
        Preconditions.checkArgument((weight > 0.0 ? 1 : 0) != 0, (String)"Weight is less than or equal to 0.0 (%s)", (Object)weight);
        InternalBiomeUtils.ensureIdMapping(primary);
        InternalBiomeUtils.ensureIdMapping(hills);
        OVERWORLD_HILLS_MAP.computeIfAbsent(primary, biome -> DefaultHillsData.injectDefaultHills(primary, new WeightedBiomePicker())).addBiome(hills, weight);
        InternalBiomeData.injectOverworldBiome(hills);
    }

    public static void addOverworldShoreBiome(RegistryKey<Biome> primary, RegistryKey<Biome> shore, double weight) {
        Preconditions.checkArgument((primary != null ? 1 : 0) != 0, (Object)"Primary biome is null");
        Preconditions.checkArgument((shore != null ? 1 : 0) != 0, (Object)"Shore biome is null");
        Preconditions.checkArgument((!Double.isNaN(weight) ? 1 : 0) != 0, (Object)"Weight is NaN");
        Preconditions.checkArgument((weight > 0.0 ? 1 : 0) != 0, (String)"Weight is less than or equal to 0.0 (%s)", (Object)weight);
        InternalBiomeUtils.ensureIdMapping(primary);
        InternalBiomeUtils.ensureIdMapping(shore);
        OVERWORLD_SHORE_MAP.computeIfAbsent(primary, biome -> new WeightedBiomePicker()).addBiome(shore, weight);
        InternalBiomeData.injectOverworldBiome(shore);
    }

    public static void addOverworldEdgeBiome(RegistryKey<Biome> primary, RegistryKey<Biome> edge, double weight) {
        Preconditions.checkArgument((primary != null ? 1 : 0) != 0, (Object)"Primary biome is null");
        Preconditions.checkArgument((edge != null ? 1 : 0) != 0, (Object)"Edge biome is null");
        Preconditions.checkArgument((!Double.isNaN(weight) ? 1 : 0) != 0, (Object)"Weight is NaN");
        Preconditions.checkArgument((weight > 0.0 ? 1 : 0) != 0, (String)"Weight is less than or equal to 0.0 (%s)", (Object)weight);
        InternalBiomeUtils.ensureIdMapping(primary);
        InternalBiomeUtils.ensureIdMapping(edge);
        OVERWORLD_EDGE_MAP.computeIfAbsent(primary, biome -> new WeightedBiomePicker()).addBiome(edge, weight);
        InternalBiomeData.injectOverworldBiome(edge);
    }

    public static void addOverworldBiomeReplacement(RegistryKey<Biome> replaced, RegistryKey<Biome> variant, double chance, Temperature[] climates) {
        Preconditions.checkArgument((replaced != null ? 1 : 0) != 0, (Object)"Replaced biome is null");
        Preconditions.checkArgument((variant != null ? 1 : 0) != 0, (Object)"Variant biome is null");
        Preconditions.checkArgument((chance > 0.0 && chance <= 1.0 ? 1 : 0) != 0, (Object)"Chance is not greater than 0 or less than or equal to 1");
        InternalBiomeUtils.ensureIdMapping(replaced);
        InternalBiomeUtils.ensureIdMapping(variant);
        OVERWORLD_VARIANT_TRANSFORMERS.computeIfAbsent(replaced, biome -> new VariantTransformer()).addBiome(variant, chance, climates);
        InternalBiomeData.injectOverworldBiome(variant);
    }

    public static void setOverworldRiverBiome(RegistryKey<Biome> primary, RegistryKey<Biome> river) {
        Preconditions.checkArgument((primary != null ? 1 : 0) != 0, (Object)"Primary biome is null");
        InternalBiomeUtils.ensureIdMapping(primary);
        InternalBiomeUtils.ensureIdMapping(river);
        OVERWORLD_RIVER_MAP.put(primary, river);
        if (river != null) {
            InternalBiomeData.injectOverworldBiome(river);
        }
    }

    private static void injectOverworldBiome(RegistryKey<Biome> biome) {
        List<RegistryKey<Biome>> biomes = OverworldBiomeSourceAccessor.getPossibleBiomes();
        if (biomes instanceof ImmutableList) {
            biomes = new ArrayList<RegistryKey<Biome>>(biomes);
            OverworldBiomeSourceAccessor.setPossibleBiomes(biomes);
        }
        biomes.add(biome);
    }

    public static Map<RegistryKey<Biome>, WeightedBiomePicker> getOverworldHills() {
        return OVERWORLD_HILLS_MAP;
    }

    public static Map<RegistryKey<Biome>, WeightedBiomePicker> getOverworldShores() {
        return OVERWORLD_SHORE_MAP;
    }

    public static Map<RegistryKey<Biome>, WeightedBiomePicker> getOverworldEdges() {
        return OVERWORLD_EDGE_MAP;
    }

    public static Map<RegistryKey<Biome>, RegistryKey<Biome>> getOverworldRivers() {
        return OVERWORLD_RIVER_MAP;
    }

    public static EnumMap<Temperature, WeightedBiomePicker> getOverworldModdedContinentalBiomePickers() {
        return OVERWORLD_MODDED_CONTINENTAL_BIOME_PICKERS;
    }

    public static Map<RegistryKey<Biome>, VariantTransformer> getOverworldVariantTransformers() {
        return OVERWORLD_VARIANT_TRANSFORMERS;
    }

    private static class DefaultHillsData {
        private static final ImmutableMap<RegistryKey<Biome>, RegistryKey<Biome>> DEFAULT_HILLS;

        private DefaultHillsData() {
        }

        static WeightedBiomePicker injectDefaultHills(RegistryKey<Biome> base, WeightedBiomePicker picker) {
            RegistryKey defaultHill = (RegistryKey)DEFAULT_HILLS.get(base);
            if (defaultHill != null) {
                picker.addBiome((RegistryKey<Biome>)defaultHill, 1.0);
            } else if (LayerUtil.func_202826_a((int)InternalBiomeUtils.getRawId(base), (int)InternalBiomeUtils.getRawId((RegistryKey<Biome>)Biomes.field_150607_aa))) {
                picker.addBiome((RegistryKey<Biome>)Biomes.field_150589_Z, 1.0);
            } else if (base == Biomes.field_150575_M || base == Biomes.field_203618_X || base == Biomes.field_203619_Y) {
                picker.addBiome((RegistryKey<Biome>)Biomes.field_76772_c, 1.0);
                picker.addBiome((RegistryKey<Biome>)Biomes.field_76767_f, 1.0);
            } else if (base == Biomes.field_203620_Z) {
                picker.addBiome((RegistryKey<Biome>)Biomes.field_76772_c, 0.25);
                picker.addBiome((RegistryKey<Biome>)Biomes.field_76767_f, 0.25);
            } else if (base == Biomes.field_76772_c) {
                picker.addBiome((RegistryKey<Biome>)Biomes.field_76785_t, 1.0);
                picker.addBiome((RegistryKey<Biome>)Biomes.field_76767_f, 2.0);
            }
            return picker;
        }

        static {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            builder.put((Object)Biomes.field_76769_d, (Object)Biomes.field_76786_s);
            builder.put((Object)Biomes.field_76767_f, (Object)Biomes.field_76785_t);
            builder.put((Object)Biomes.field_150583_P, (Object)Biomes.field_150582_Q);
            builder.put((Object)Biomes.field_150585_R, (Object)Biomes.field_76772_c);
            builder.put((Object)Biomes.field_76768_g, (Object)Biomes.field_76784_u);
            builder.put((Object)Biomes.field_150578_U, (Object)Biomes.field_150581_V);
            builder.put((Object)Biomes.field_150584_S, (Object)Biomes.field_150579_T);
            builder.put((Object)Biomes.field_76774_n, (Object)Biomes.field_76775_o);
            builder.put((Object)Biomes.field_76782_w, (Object)Biomes.field_76792_x);
            builder.put((Object)Biomes.field_222370_aw, (Object)Biomes.field_222371_ax);
            builder.put((Object)Biomes.field_76771_b, (Object)Biomes.field_150575_M);
            builder.put((Object)Biomes.field_203615_U, (Object)Biomes.field_203618_X);
            builder.put((Object)Biomes.field_203616_V, (Object)Biomes.field_203619_Y);
            builder.put((Object)Biomes.field_76776_l, (Object)Biomes.field_203620_Z);
            builder.put((Object)Biomes.field_76770_e, (Object)Biomes.field_150580_W);
            builder.put((Object)Biomes.field_150588_X, (Object)Biomes.field_150587_Y);
            DEFAULT_HILLS = builder.build();
        }
    }
}

