/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.common.worldgen.biome;

import com.blackgear.platform.Platform;
import com.blackgear.platform.common.worldgen.biome.InternalBiomeData;
import com.blackgear.platform.common.worldgen.biome.VariantTransformer;
import com.blackgear.platform.common.worldgen.biome.WeightedBiomeEntry;
import com.blackgear.platform.common.worldgen.biome.WeightedBiomePicker;
import com.blackgear.platform.common.worldgen.parameters.Temperature;
import com.blackgear.platform.core.mixin.access.BiomesAccessor;
import com.blackgear.platform.core.mixin.forge.core.access.RegionHillsLayerAccessor;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import java.util.Map;
import java.util.function.IntConsumer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeRegistry;
import net.minecraft.world.gen.INoiseRandom;

public class InternalBiomeUtils {
    public static boolean isEdge(int north, int east, int south, int west, int center) {
        return InternalBiomeUtils.areUnsimilar(center, north) || InternalBiomeUtils.areUnsimilar(center, east) || InternalBiomeUtils.areUnsimilar(center, south) || InternalBiomeUtils.areUnsimilar(center, west);
    }

    private static boolean areUnsimilar(int mainBiomeId, int secondaryBiomeId) {
        if (mainBiomeId == secondaryBiomeId) {
            return false;
        }
        Int2IntMap parentChildMap = RegionHillsLayerAccessor.getMUTATIONS();
        return parentChildMap.get(mainBiomeId) != secondaryBiomeId && parentChildMap.get(secondaryBiomeId) != mainBiomeId;
    }

    public static boolean neighborsOcean(int north, int east, int south, int west) {
        return InternalBiomeUtils.isOceanBiome(north) || InternalBiomeUtils.isOceanBiome(east) || InternalBiomeUtils.isOceanBiome(south) || InternalBiomeUtils.isOceanBiome(west);
    }

    private static boolean isOceanBiome(int id) {
        Biome biome = (Biome)WorldGenRegistries.field_243657_i.func_148745_a(id);
        return biome != null && biome.func_201856_r() == Biome.Category.OCEAN;
    }

    public static int searchForBiome(double reqWeightSum, int vanillaArrayWeight, List<WeightedBiomeEntry> moddedBiomes) {
        reqWeightSum -= (double)vanillaArrayWeight;
        int low = 0;
        int high = moddedBiomes.size() - 1;
        while (low < high) {
            int mid = high + low >>> 1;
            if (reqWeightSum < moddedBiomes.get(mid).getUpperWeightBound()) {
                high = mid;
                continue;
            }
            low = mid + 1;
        }
        return low;
    }

    public static int transformBiome(INoiseRandom random, RegistryKey<Biome> existing, Temperature climate) {
        Map<RegistryKey<Biome>, VariantTransformer> overworldVariantTransformers = InternalBiomeData.getOverworldVariantTransformers();
        VariantTransformer transformer = overworldVariantTransformers.get(existing);
        if (transformer != null) {
            RegistryKey<Biome> key = transformer.transformBiome(existing, random, climate);
            return InternalBiomeUtils.getRawId(key);
        }
        return InternalBiomeUtils.getRawId(existing);
    }

    public static void injectBiomesIntoClimate(INoiseRandom random, int[] vanillaArray, Temperature climate, IntConsumer result) {
        WeightedBiomePicker picker = InternalBiomeData.getOverworldModdedContinentalBiomePickers().get((Object)climate);
        if (picker == null || picker.getCurrentWeightTotal() <= 0.0) {
            return;
        }
        int vanillaArrayWeight = vanillaArray.length;
        double reqWeightSum = (double)random.func_202696_a(Integer.MAX_VALUE) * ((double)vanillaArray.length + picker.getCurrentWeightTotal()) / 2.147483647E9;
        if (reqWeightSum < (double)vanillaArray.length) {
            result.accept(InternalBiomeUtils.transformBiome(random, (RegistryKey<Biome>)BiomeRegistry.func_244203_a((int)vanillaArray[(int)reqWeightSum]), climate));
        } else {
            WeightedBiomeEntry found = picker.search(reqWeightSum - (double)vanillaArrayWeight);
            result.accept(InternalBiomeUtils.transformBiome(random, found.getBiome(), climate));
        }
    }

    public static int getRawId(RegistryKey<Biome> key) {
        return WorldGenRegistries.field_243657_i.func_148757_b((Object)((Biome)WorldGenRegistries.field_243657_i.func_243576_d(key)));
    }

    public static void ensureIdMapping(RegistryKey<Biome> biomeKey) {
        int rawId = InternalBiomeUtils.getRawId(biomeKey);
        Int2ObjectMap<RegistryKey<Biome>> biomes = BiomesAccessor.getTO_NAME();
        if (!biomes.containsKey(rawId)) {
            Platform.LOGGER.debug("Automatically creating layer-related raw-id mapping for biome {}", biomeKey);
            biomes.put(rawId, biomeKey);
        }
    }
}

