/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.common.worldgen.biome;

import com.blackgear.platform.common.worldgen.biome.BiomeVariant;
import com.blackgear.platform.common.worldgen.parameters.Temperature;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.INoiseRandom;

public final class VariantTransformer {
    private final SubTransformer defaultTransformer = new SubTransformer();
    private final Map<Temperature, SubTransformer> transformers = new HashMap<Temperature, SubTransformer>();

    void addBiome(RegistryKey<Biome> variant, double chance, Temperature[] climates) {
        if (climates == null || climates.length == 0) {
            this.defaultTransformer.addBiome((RegistryKey<Biome>)variant, chance);
            climates = Temperature.values();
        }
        for (Temperature climate : climates) {
            this.transformers.computeIfAbsent(climate, c -> new SubTransformer()).addBiome((RegistryKey<Biome>)variant, chance);
        }
    }

    RegistryKey<Biome> transformBiome(RegistryKey<Biome> replaced, INoiseRandom random, Temperature climate) {
        if (climate == null) {
            return this.defaultTransformer.transformBiome((RegistryKey<Biome>)replaced, random);
        }
        SubTransformer transformer = this.transformers.get((Object)climate);
        if (transformer != null) {
            return transformer.transformBiome((RegistryKey<Biome>)replaced, random);
        }
        return replaced;
    }

    static final class SubTransformer {
        private final List<BiomeVariant> variants = new ArrayList<BiomeVariant>();

        SubTransformer() {
        }

        private void addBiome(RegistryKey<Biome> variant, double chance) {
            this.variants.add(new BiomeVariant(variant, chance));
        }

        private RegistryKey<Biome> transformBiome(RegistryKey<Biome> replaced, INoiseRandom random) {
            for (BiomeVariant variant : this.variants) {
                if (!((double)random.func_202696_a(Integer.MAX_VALUE) < variant.getChance() * 2.147483647E9)) continue;
                return variant.getVariant();
            }
            return replaced;
        }
    }
}

