/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.common.worldgen.biome;

import com.blackgear.platform.common.worldgen.biome.WeightedBiomeEntry;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.INoiseRandom;

public final class WeightedBiomePicker {
    private double currentTotal = 0.0;
    private final List<WeightedBiomeEntry> entries = Collections.synchronizedList(new ArrayList());

    WeightedBiomePicker() {
    }

    void addBiome(RegistryKey<Biome> biome, double weight) {
        this.currentTotal += weight;
        this.entries.add(new WeightedBiomeEntry(biome, weight, this.currentTotal));
    }

    double getCurrentWeightTotal() {
        return this.currentTotal;
    }

    public RegistryKey<Biome> pickRandom(INoiseRandom random) {
        double target = (double)random.func_202696_a(Integer.MAX_VALUE) * this.getCurrentWeightTotal() / 2.147483647E9;
        return this.search(target).getBiome();
    }

    public RegistryKey<Biome> pickFromNoise(INoiseRandom source, double x, double y, double z) {
        double target = Math.abs(source.func_205589_a().func_215456_a(x, y, z, 0.0, 0.0)) * this.getCurrentWeightTotal();
        return this.search(target).getBiome();
    }

    public WeightedBiomeEntry search(double target) {
        Preconditions.checkArgument((target <= this.currentTotal ? 1 : 0) != 0, (Object)"The provided target value for biome selection must be less than or equal to the weight total");
        Preconditions.checkArgument((target >= 0.0 ? 1 : 0) != 0, (Object)"The provided target value for biome selection cannot be negative");
        int low = 0;
        int high = this.entries.size() - 1;
        while (low < high) {
            int mid = high + low >>> 1;
            if (target < this.entries.get(mid).getUpperWeightBound()) {
                high = mid;
                continue;
            }
            low = mid + 1;
        }
        return this.entries.get(low);
    }
}

