/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.common.worldgen.decorator;

import com.blackgear.platform.common.worldgen.CaveSurface;
import com.blackgear.platform.common.worldgen.Column;
import com.blackgear.platform.common.worldgen.decorator.CaveSurfaceConfiguration;
import com.blackgear.platform.core.mixin.access.DecorationContextAccessor;
import com.blackgear.platform.core.util.BlockUtils;
import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Random;
import java.util.stream.Stream;
import net.minecraft.block.AbstractBlock;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.feature.WorldDecoratingHelper;
import net.minecraft.world.gen.placement.Placement;

public class CaveSurfaceDecorator
extends Placement<CaveSurfaceConfiguration> {
    public CaveSurfaceDecorator(Codec<CaveSurfaceConfiguration> codec) {
        super(codec);
    }

    public Stream<BlockPos> getPositions(WorldDecoratingHelper helper, Random random, CaveSurfaceConfiguration config, BlockPos origin) {
        Optional<Column> column = Column.scan((IWorldGenerationBaseReader)((DecorationContextAccessor)helper).getLevel(), origin, config.floorToCeilingSearchRange, AbstractBlock.AbstractBlockState::func_196958_f, state -> state.func_185904_a().func_76220_a());
        if (!column.isPresent()) {
            return Stream.empty();
        }
        OptionalInt surface = config.surface == CaveSurface.CEILING ? column.get().getCeiling() : column.get().getFloor();
        return !surface.isPresent() ? Stream.empty() : Stream.of(BlockUtils.atY(origin, surface.getAsInt() - config.surface.getY()));
    }
}

