/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.common.worldgen.decorator;

import com.blackgear.platform.common.providers.math.ConstantInt;
import com.blackgear.platform.common.providers.math.IntProvider;
import com.blackgear.platform.common.registry.PlatformDecorators;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.world.gen.placement.ConfiguredPlacement;
import net.minecraft.world.gen.placement.IPlacementConfig;

public class RandomOffsetConfiguration
implements IPlacementConfig {
    public static final Codec<RandomOffsetConfiguration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)IntProvider.createCodec(-16, 16).fieldOf("xz_spread").forGetter(config -> config.xzSpread), (App)IntProvider.createCodec(-16, 16).fieldOf("y_spread").forGetter(config -> config.ySpread)).apply((Applicative)instance, RandomOffsetConfiguration::new));
    public final IntProvider xzSpread;
    public final IntProvider ySpread;

    public RandomOffsetConfiguration(IntProvider xzSpread, IntProvider ySpread) {
        this.xzSpread = xzSpread;
        this.ySpread = ySpread;
    }

    public static ConfiguredPlacement<?> of(IntProvider xzSpread, IntProvider ySpread) {
        return PlatformDecorators.RANDOM_OFFSET.get().func_227446_a_((IPlacementConfig)new RandomOffsetConfiguration(xzSpread, ySpread));
    }

    public static ConfiguredPlacement<?> vertical(IntProvider ySpread) {
        return RandomOffsetConfiguration.of(ConstantInt.ZERO, ySpread);
    }

    public static ConfiguredPlacement<?> horizontal(IntProvider xzSpread) {
        return RandomOffsetConfiguration.of(xzSpread, ConstantInt.ZERO);
    }
}

