/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.common.worldgen.feature;

import com.blackgear.platform.common.block.entries.MultifaceBlock;
import com.blackgear.platform.core.util.DirectionUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.util.Direction;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.gen.feature.IFeatureConfig;

public class MultifaceGrowthConfiguration
implements IFeatureConfig {
    public static final Codec<MultifaceGrowthConfiguration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Registry.field_212618_g.fieldOf("block").flatXmap(MultifaceGrowthConfiguration::apply, DataResult::success).forGetter(config -> config.placeBlock), (App)Codec.intRange((int)1, (int)64).fieldOf("search_range").orElse((Object)10).forGetter(config -> config.searchRange), (App)Codec.BOOL.fieldOf("can_place_on_floor").orElse((Object)false).forGetter(config -> config.canPlaceOnFloor), (App)Codec.BOOL.fieldOf("can_place_on_ceiling").orElse((Object)false).forGetter(config -> config.canPlaceOnCeiling), (App)Codec.BOOL.fieldOf("can_place_on_wall").orElse((Object)false).forGetter(config -> config.canPlaceOnWall), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("chance_of_spreading").orElse((Object)Float.valueOf(0.5f)).forGetter(config -> Float.valueOf(config.chanceOfSpreading)), (App)Registry.field_212618_g.listOf().fieldOf("can_be_placed_on").xmap(ImmutableSet::copyOf, ImmutableList::copyOf).forGetter(config -> (ImmutableSet)config.canBePlacedOn)).apply((Applicative)instance, MultifaceGrowthConfiguration::new));
    public final MultifaceBlock placeBlock;
    public final int searchRange;
    public final boolean canPlaceOnFloor;
    public final boolean canPlaceOnCeiling;
    public final boolean canPlaceOnWall;
    public final float chanceOfSpreading;
    public final Set<Block> canBePlacedOn;
    private final ObjectArrayList<Direction> validDirections;

    private static DataResult<MultifaceBlock> apply(Block block) {
        if (block instanceof MultifaceBlock) {
            return DataResult.success((Object)((Object)((MultifaceBlock)block)));
        }
        return DataResult.error((String)"Growth block should be a multiface block");
    }

    public MultifaceGrowthConfiguration(MultifaceBlock placeBlock, int searchRange, boolean canPlaceOnFloor, boolean canPlaceOnCeiling, boolean canPlaceOnWall, float chanceOfSpreading, Set<Block> canBePlacedOn) {
        this.placeBlock = placeBlock;
        this.searchRange = searchRange;
        this.canPlaceOnFloor = canPlaceOnFloor;
        this.canPlaceOnCeiling = canPlaceOnCeiling;
        this.canPlaceOnWall = canPlaceOnWall;
        this.chanceOfSpreading = chanceOfSpreading;
        this.canBePlacedOn = canBePlacedOn;
        this.validDirections = new ObjectArrayList(6);
        if (canPlaceOnCeiling) {
            this.validDirections.add((Object)Direction.UP);
        }
        if (canPlaceOnFloor) {
            this.validDirections.add((Object)Direction.DOWN);
        }
        if (canPlaceOnWall) {
            Direction.Plane horizontal = Direction.Plane.HORIZONTAL;
            horizontal.forEach(arg_0 -> this.validDirections.add(arg_0));
        }
    }

    public List<Direction> getShuffledDirectionsExcept(Random random, Direction direction) {
        return DirectionUtils.toShuffledList(this.validDirections.stream().filter(dir -> dir != direction), random);
    }

    public List<Direction> getShuffledDirections(Random random) {
        return DirectionUtils.shuffledCopy(this.validDirections, random);
    }
}

