/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.common.worldgen.feature;

import com.blackgear.platform.common.worldgen.feature.MultifaceGrowthConfiguration;
import com.blackgear.platform.core.util.BlockUtils;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;

public class MultifaceGrowthFeature
extends Feature<MultifaceGrowthConfiguration> {
    public MultifaceGrowthFeature(Codec<MultifaceGrowthConfiguration> codec) {
        super(codec);
    }

    public boolean place(ISeedReader level, ChunkGenerator generator, Random random, BlockPos origin, MultifaceGrowthConfiguration config) {
        if (!BlockUtils.isAirOrWater(level.func_180495_p(origin))) {
            return false;
        }
        List<Direction> shuffledDirections = config.getShuffledDirections(random);
        if (this.placeGrowthIfPossible(level, origin, level.func_180495_p(origin), config, random, shuffledDirections)) {
            return true;
        }
        BlockPos.Mutable mutable = origin.func_239590_i_();
        block0: for (Direction direction : shuffledDirections) {
            mutable.func_189533_g((Vector3i)origin);
            List<Direction> shuffledDirectionsExcept = config.getShuffledDirectionsExcept(random, direction.func_176734_d());
            for (int i = 0; i < config.searchRange; ++i) {
                mutable.func_239622_a_((Vector3i)origin, direction);
                BlockState state = level.func_180495_p((BlockPos)mutable);
                if (!BlockUtils.isAirOrWater(state) && !state.func_203425_a((Block)config.placeBlock)) continue block0;
                if (!this.placeGrowthIfPossible(level, (BlockPos)mutable, state, config, random, shuffledDirectionsExcept)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean placeGrowthIfPossible(ISeedReader level, BlockPos pos, BlockState state, MultifaceGrowthConfiguration config, Random random, List<Direction> directions) {
        BlockPos.Mutable mutable = pos.func_239590_i_();
        for (Direction direction : directions) {
            BlockState placementState;
            BlockState neighborState = level.func_180495_p((BlockPos)mutable.func_239622_a_((Vector3i)pos, direction));
            if (!config.canBePlacedOn.contains(neighborState.func_177230_c()) || (placementState = config.placeBlock.getStateForPlacement(state, (IBlockReader)level, pos, direction)) == null) continue;
            level.func_180501_a(pos, placementState, 3);
            level.func_217349_x(pos).func_201594_d(pos);
            if (random.nextFloat() < config.chanceOfSpreading) {
                config.placeBlock.getSpreader().spreadFromFaceTowardRandomDirection(placementState, (IWorld)level, pos, direction, random, true);
            }
            return true;
        }
        return false;
    }
}

