/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.common.worldgen.feature;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.template.BlockMatchRuleTest;
import net.minecraft.world.gen.feature.template.RuleTest;

public class OverlayOreConfiguration
implements IFeatureConfig {
    public static final Codec<OverlayOreConfiguration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list(TargetBlockState.CODEC).fieldOf("targets").forGetter(config -> config.targets), (App)Codec.intRange((int)0, (int)64).fieldOf("size").forGetter(config -> config.size), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("discard_chance_on_air_exposure").forGetter(config -> Float.valueOf(config.discardChanceOnAirExposure))).apply((Applicative)instance, OverlayOreConfiguration::new));
    public final List<TargetBlockState> targets;
    public final int size;
    public final float discardChanceOnAirExposure;

    public OverlayOreConfiguration(List<TargetBlockState> targets, int size, float discardChanceOnAirExposure) {
        this.targets = targets;
        this.size = size;
        this.discardChanceOnAirExposure = discardChanceOnAirExposure;
    }

    public OverlayOreConfiguration(List<TargetBlockState> targets, int size) {
        this(targets, size, 0.0f);
    }

    public OverlayOreConfiguration(RuleTest target, BlockState state, int size, float discardChanceOnAirExposure) {
        this((List<TargetBlockState>)ImmutableList.of((Object)OverlayOreConfiguration.target(target, state)), size, discardChanceOnAirExposure);
    }

    public OverlayOreConfiguration(RuleTest target, BlockState state, int size) {
        this(target, state, size, 0.0f);
    }

    public static TargetBlockState target(RuleTest target, BlockState state) {
        return new TargetBlockState(target, state);
    }

    public static TargetBlockState target(Block target, Block block) {
        return new TargetBlockState((RuleTest)new BlockMatchRuleTest(target), block.func_176223_P());
    }

    public static class TargetBlockState {
        public final RuleTest target;
        public final BlockState state;
        public static final Codec<TargetBlockState> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RuleTest.field_237127_c_.fieldOf("target").forGetter(config -> config.target), (App)BlockState.field_235877_b_.fieldOf("state").forGetter(config -> config.state)).apply((Applicative)instance, TargetBlockState::new));

        public TargetBlockState(RuleTest target, BlockState state) {
            this.target = target;
            this.state = state;
        }
    }
}

