/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.common.worldgen.feature;

import com.blackgear.platform.common.worldgen.BulkSectionAccess;
import com.blackgear.platform.common.worldgen.feature.OverlayOreConfiguration;
import com.mojang.serialization.Codec;
import java.util.BitSet;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.SectionPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;

public class OverlayOreFeature
extends Feature<OverlayOreConfiguration> {
    public OverlayOreFeature(Codec<OverlayOreConfiguration> codec) {
        super(codec);
    }

    public boolean place(ISeedReader level, ChunkGenerator generator, Random random, BlockPos origin, OverlayOreConfiguration config) {
        float angle = random.nextFloat() * (float)Math.PI;
        float sizeFactor = (float)config.size / 8.0f;
        int radius = MathHelper.func_76123_f((float)(((float)config.size / 16.0f * 2.0f + 1.0f) / 2.0f));
        double x1 = (double)origin.func_177958_n() + Math.sin(angle) * (double)sizeFactor;
        double x2 = (double)origin.func_177958_n() - Math.sin(angle) * (double)sizeFactor;
        double z1 = (double)origin.func_177952_p() + Math.cos(angle) * (double)sizeFactor;
        double z2 = (double)origin.func_177952_p() - Math.cos(angle) * (double)sizeFactor;
        double y1 = origin.func_177956_o() + random.nextInt(3) - 2;
        double y2 = origin.func_177956_o() + random.nextInt(3) - 2;
        int minX = origin.func_177958_n() - MathHelper.func_76123_f((float)sizeFactor) - radius;
        int minY = origin.func_177956_o() - 2 - radius;
        int minZ = origin.func_177952_p() - MathHelper.func_76123_f((float)sizeFactor) - radius;
        int rangeXZ = 2 * (MathHelper.func_76123_f((float)sizeFactor) + radius);
        int rangeY = 2 * (2 + radius);
        for (int x = minX; x <= minX + rangeXZ; ++x) {
            for (int z = minZ; z <= minZ + rangeXZ; ++z) {
                if (minY > level.func_201676_a(Heightmap.Type.OCEAN_FLOOR_WG, x, z)) continue;
                return this.doPlace(level, random, config, x1, x2, z1, z2, y1, y2, minX, minY, minZ, rangeXZ, rangeY);
            }
        }
        return false;
    }

    private boolean doPlace(ISeedReader level, Random random, OverlayOreConfiguration config, double x1, double x2, double z1, double z2, double y1, double y2, int minX, int minY, int minZ, int rangeXZ, int rangeY) {
        int placedBlocks = 0;
        BitSet visitedPositions = new BitSet(rangeXZ * rangeY * rangeXZ);
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        int size = config.size;
        double[] distances = new double[size * 4];
        for (int index = 0; index < size; ++index) {
            float normal = (float)index / (float)size;
            double posX = MathHelper.func_219803_d((double)normal, (double)x1, (double)x2);
            double posY = MathHelper.func_219803_d((double)normal, (double)y1, (double)y2);
            double posZ = MathHelper.func_219803_d((double)normal, (double)z1, (double)z2);
            double radius = random.nextDouble() * (double)size / 16.0;
            double weight = ((double)(MathHelper.func_76126_a((float)((float)Math.PI * normal)) + 1.0f) * radius + 1.0) / 2.0;
            distances[index * 4] = posX;
            distances[index * 4 + 1] = posY;
            distances[index * 4 + 2] = posZ;
            distances[index * 4 + 3] = weight;
        }
        for (int p1 = 0; p1 < size - 1; ++p1) {
            if (!(distances[p1 * 4 + 3] > 0.0)) continue;
            for (int p2 = p1 + 1; p2 < size; ++p2) {
                double dz;
                double dy;
                double dx;
                double distSqr;
                if (!(distances[p2 * 4 + 3] > 0.0) || !((distSqr = distances[p1 * 4 + 3] - distances[p2 * 4 + 3]) * distSqr > (dx = distances[p1 * 4] - distances[p2 * 4]) * dx + (dy = distances[p1 * 4 + 1] - distances[p2 * 4 + 1]) * dy + (dz = distances[p1 * 4 + 2] - distances[p2 * 4 + 2]) * dz)) continue;
                if (distSqr > 0.0) {
                    distances[p2 * 4 + 3] = -1.0;
                    continue;
                }
                distances[p1 * 4 + 3] = -1.0;
            }
        }
        try (BulkSectionAccess bulkSection = new BulkSectionAccess((IWorld)level);){
            for (int i = 0; i < size; ++i) {
                double weight = distances[i * 4 + 3];
                if (!(weight >= 0.0)) continue;
                double x = distances[i * 4];
                double y = distances[i * 4 + 1];
                double z = distances[i * 4 + 2];
                int startX = Math.max(MathHelper.func_76128_c((double)(x - weight)), minX);
                int startY = Math.max(MathHelper.func_76128_c((double)(y - weight)), minY);
                int startZ = Math.max(MathHelper.func_76128_c((double)(z - weight)), minZ);
                int endX = Math.max(MathHelper.func_76128_c((double)(x + weight)), startX);
                int endY = Math.max(MathHelper.func_76128_c((double)(y + weight)), startY);
                int endZ = Math.max(MathHelper.func_76128_c((double)(z + weight)), startZ);
                for (int posX = startX; posX <= endX; ++posX) {
                    double dx = ((double)posX + 0.5 - x) / weight;
                    if (!(dx * dx < 1.0)) continue;
                    for (int posY = startY; posY <= endY; ++posY) {
                        double dy = ((double)posY + 0.5 - y) / weight;
                        if (!(dx * dx + dy * dy < 1.0)) continue;
                        block11: for (int posZ = startZ; posZ <= endZ; ++posZ) {
                            int index;
                            double dz = ((double)posZ + 0.5 - z) / weight;
                            if (!(dx * dx + dy * dy + dz * dz < 1.0) || World.func_217405_b((int)posY) || visitedPositions.get(index = posX - minX + (posY - minY) * rangeXZ + (posZ - minZ) * rangeXZ * rangeY)) continue;
                            visitedPositions.set(index);
                            mutable.func_181079_c(posX, posY, posZ);
                            ChunkSection chunkSection = bulkSection.getSection((BlockPos)mutable);
                            if (chunkSection == null) continue;
                            int sectionX = SectionPos.func_218171_b((int)posX);
                            int sectionY = SectionPos.func_218171_b((int)posY);
                            int sectionZ = SectionPos.func_218171_b((int)posZ);
                            BlockState state = chunkSection.func_177485_a(sectionX, sectionY, sectionZ);
                            for (OverlayOreConfiguration.TargetBlockState target : config.targets) {
                                if (!this.canPlaceOre(state, bulkSection::getBlockState, random, config, target, mutable)) continue;
                                chunkSection.func_177484_a(sectionX, sectionY, sectionZ, target.state, false);
                                ++placedBlocks;
                                continue block11;
                            }
                        }
                    }
                }
            }
        }
        return placedBlocks > 0;
    }

    private boolean canPlaceOre(BlockState state, Function<BlockPos, BlockState> stateByPos, Random random, OverlayOreConfiguration config, OverlayOreConfiguration.TargetBlockState target, BlockPos.Mutable mutable) {
        if (!target.target.func_215181_a(state, random)) {
            return false;
        }
        if (this.shouldSkipAirCheck(random, config.discardChanceOnAirExposure)) {
            return true;
        }
        return !this.isAdjacentToAir(stateByPos, (BlockPos)mutable);
    }

    private boolean shouldSkipAirCheck(Random random, float discardChanceOnAirExposure) {
        if (discardChanceOnAirExposure <= 0.0f) {
            return true;
        }
        if (discardChanceOnAirExposure >= 1.0f) {
            return false;
        }
        return random.nextFloat() >= discardChanceOnAirExposure;
    }

    private boolean isAdjacentToAir(Function<BlockPos, BlockState> stateByPos, BlockPos pos) {
        return this.checkNeighbors(stateByPos, pos, AbstractBlock.AbstractBlockState::func_196958_f);
    }

    private boolean checkNeighbors(Function<BlockPos, BlockState> stateByPos, BlockPos pos, Predicate<BlockState> state) {
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        for (Direction direction : Direction.values()) {
            mutable.func_239622_a_((Vector3i)pos, direction);
            if (!state.test(stateByPos.apply((BlockPos)mutable))) continue;
            return true;
        }
        return false;
    }
}

