/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.common.worldgen.feature;

import com.blackgear.platform.common.worldgen.feature.VegetationPatchConfiguration;
import com.mojang.serialization.Codec;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;

public class VegetationPatchFeature
extends Feature<VegetationPatchConfiguration> {
    public VegetationPatchFeature(Codec<VegetationPatchConfiguration> codec) {
        super(codec);
    }

    public boolean place(ISeedReader level, ChunkGenerator generator, Random random, BlockPos origin, VegetationPatchConfiguration config) {
        Predicate<BlockState> replaceableBlocks = this.getReplaceableBlocks(config);
        int xRadius = config.xzRadius.sample(random) + 1;
        int zRadius = config.xzRadius.sample(random) + 1;
        Set<BlockPos> possiblePositions = this.placeGroundPatch(level, config, random, origin, replaceableBlocks, xRadius, zRadius);
        this.distributeVegetation(level, config, random, possiblePositions, generator);
        return !possiblePositions.isEmpty();
    }

    protected Set<BlockPos> placeGroundPatch(ISeedReader level, VegetationPatchConfiguration config, Random random, BlockPos pos, Predicate<BlockState> replaceableBlocks, int xRadius, int zRadius) {
        BlockPos.Mutable currentPos = pos.func_239590_i_();
        BlockPos.Mutable nextPos = currentPos.func_239590_i_();
        Direction direction = config.surface.getDirection();
        Direction oppositeDirection = direction.func_176734_d();
        HashSet<BlockPos> possiblePositions = new HashSet<BlockPos>();
        for (int x = -xRadius; x <= xRadius; ++x) {
            boolean isXEdge = x == -xRadius || x == xRadius;
            for (int z = -zRadius; z <= zRadius; ++z) {
                int y;
                boolean isEdgeNotCorner;
                boolean isZEdge = z == -zRadius || z == zRadius;
                boolean isEdge = isXEdge || isZEdge;
                boolean isCorner = isXEdge && isZEdge;
                boolean bl = isEdgeNotCorner = isEdge && !isCorner;
                if (isCorner || isEdgeNotCorner && (config.extraEdgeColumnChance == 0.0f || !(random.nextFloat() <= config.extraEdgeColumnChance))) continue;
                currentPos.func_239621_a_((Vector3i)pos, x, 0, z);
                for (y = 0; level.func_217375_a((BlockPos)currentPos, AbstractBlock.AbstractBlockState::func_196958_f) && y < config.verticalRange; ++y) {
                    currentPos.func_189536_c(direction);
                }
                for (y = 0; level.func_217375_a((BlockPos)currentPos, state -> !state.func_196958_f()) && y < config.verticalRange; ++y) {
                    currentPos.func_189536_c(oppositeDirection);
                }
                nextPos.func_239622_a_((Vector3i)currentPos, config.surface.getDirection());
                BlockState nextState = level.func_180495_p((BlockPos)nextPos);
                if (!level.func_175623_d((BlockPos)currentPos) || !nextState.func_224755_d((IBlockReader)level, (BlockPos)nextPos, config.surface.getDirection().func_176734_d())) continue;
                int depth = config.depth.sample(random) + (config.extraBottomBlockChance > 0.0f && random.nextFloat() < config.extraBottomBlockChance ? 1 : 0);
                BlockPos position = nextPos.func_185334_h();
                boolean isPlaced = this.placeGround(level, config, replaceableBlocks, random, nextPos, depth);
                if (!isPlaced) continue;
                possiblePositions.add(position);
            }
        }
        return possiblePositions;
    }

    protected void distributeVegetation(ISeedReader level, VegetationPatchConfiguration config, Random random, Set<BlockPos> possiblePositions, ChunkGenerator generator) {
        for (BlockPos pos : possiblePositions) {
            if (!(config.vegetationChance > 0.0f) || !(random.nextFloat() < config.vegetationChance)) continue;
            this.placeVegetation(level, config, generator, random, pos);
        }
    }

    protected boolean placeVegetation(ISeedReader level, VegetationPatchConfiguration config, ChunkGenerator generator, Random random, BlockPos pos) {
        return config.vegetationFeature.get().func_242765_a(level, generator, random, pos.func_177972_a(config.surface.getDirection().func_176734_d()));
    }

    protected boolean placeGround(ISeedReader level, VegetationPatchConfiguration config, Predicate<BlockState> replaceableBlocks, Random random, BlockPos.Mutable mutable, int maxDistance) {
        for (int i = 0; i < maxDistance; ++i) {
            BlockState currentState;
            BlockState groundState = config.groundState.func_225574_a_(random, (BlockPos)mutable);
            if (groundState.func_203425_a((currentState = level.func_180495_p((BlockPos)mutable)).func_177230_c())) continue;
            if (!replaceableBlocks.test(currentState)) {
                return i != 0;
            }
            level.func_180501_a((BlockPos)mutable, groundState, 2);
            mutable.func_189536_c(config.surface.getDirection());
        }
        return true;
    }

    private Predicate<BlockState> getReplaceableBlocks(VegetationPatchConfiguration config) {
        ITag tag = BlockTags.func_199896_a().func_199910_a(config.replaceable);
        return tag == null ? state -> true : state -> state.func_235714_a_(tag);
    }
}

