/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.common.worldgen.feature;

import com.blackgear.platform.common.worldgen.feature.VegetationPatchConfiguration;
import com.blackgear.platform.common.worldgen.feature.VegetationPatchFeature;
import com.mojang.serialization.Codec;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;

public class WaterloggedVegetationPatchFeature
extends VegetationPatchFeature {
    public WaterloggedVegetationPatchFeature(Codec<VegetationPatchConfiguration> codec) {
        super(codec);
    }

    @Override
    protected Set<BlockPos> placeGroundPatch(ISeedReader level, VegetationPatchConfiguration config, Random random, BlockPos pos, Predicate<BlockState> replaceableBlocks, int xRadius, int zRadius) {
        Set<BlockPos> positions = super.placeGroundPatch(level, config, random, pos, replaceableBlocks, xRadius, zRadius);
        HashSet<BlockPos> waterloggablePositions = new HashSet<BlockPos>();
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        for (BlockPos position : positions) {
            if (WaterloggedVegetationPatchFeature.isExposed(level, positions, position, mutable)) continue;
            waterloggablePositions.add(position);
        }
        for (BlockPos position : waterloggablePositions) {
            level.func_180501_a(position, Blocks.field_150355_j.func_176223_P(), 2);
        }
        return waterloggablePositions;
    }

    private static boolean isExposed(ISeedReader level, Set<BlockPos> positions, BlockPos pos, BlockPos.Mutable mutable) {
        return WaterloggedVegetationPatchFeature.isExposedDirection(level, pos, mutable, Direction.NORTH) || WaterloggedVegetationPatchFeature.isExposedDirection(level, pos, mutable, Direction.SOUTH) || WaterloggedVegetationPatchFeature.isExposedDirection(level, pos, mutable, Direction.EAST) || WaterloggedVegetationPatchFeature.isExposedDirection(level, pos, mutable, Direction.WEST) || WaterloggedVegetationPatchFeature.isExposedDirection(level, pos, mutable, Direction.DOWN);
    }

    private static boolean isExposedDirection(ISeedReader level, BlockPos pos, BlockPos.Mutable mutable, Direction direction) {
        mutable.func_239622_a_((Vector3i)pos, direction);
        return !level.func_180495_p((BlockPos)mutable).func_224755_d((IBlockReader)level, (BlockPos)mutable, direction.func_176734_d());
    }

    @Override
    protected boolean placeVegetation(ISeedReader level, VegetationPatchConfiguration config, ChunkGenerator generator, Random random, BlockPos pos) {
        if (super.placeVegetation(level, config, generator, random, pos.func_177977_b())) {
            BlockState state = level.func_180495_p(pos);
            if (state.func_235901_b_((Property)BlockStateProperties.field_208198_y) && !((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue()) {
                level.func_180501_a(pos, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(true)), 2);
            }
            return true;
        }
        return false;
    }
}

