/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.common.worldgen.modifier;

import com.blackgear.platform.core.mixin.access.OverworldBiomeSourceAccessor;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.feature.ConfiguredFeature;

public interface BiomeContext {
    public static final Predicate<BiomeContext> OVERWORLD_BIOME = context -> OverworldBiomeSourceAccessor.getPossibleBiomes().contains(context.key());

    public RegistryKey<Biome> key();

    public Biome biome();

    public boolean is(Biome.Category var1);

    public boolean is(RegistryKey<Biome> var1);

    public boolean is(Predicate<BiomeContext> var1);

    public boolean hasFeature(ConfiguredFeature<?, ?> var1);

    default public boolean hasEntity(Supplier<EntityType<?>> ... entities) {
        return this.hasEntity((Set<Supplier<EntityType<?>>>)ImmutableSet.copyOf((Object[])entities));
    }

    default public boolean hasEntity(Set<Supplier<EntityType<?>>> entitySet) {
        Set entities = entitySet.stream().map(Supplier::get).collect(Collectors.toSet());
        MobSpawnInfo settings = this.biome().func_242433_b();
        return Arrays.stream(EntityClassification.values()).flatMap(category -> settings.func_242559_a(category).stream()).anyMatch(spawner -> entities.contains(spawner.field_242588_c));
    }
}

