/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.common.worldgen.modifier;

import com.blackgear.platform.common.worldgen.modifier.BiomeContext;
import java.util.function.BiConsumer;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.carver.ConfiguredCarver;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilder;

public abstract class BiomeWriter {
    public void add(BiConsumer<BiomeWriter, BiomeContext> modifier) {
        modifier.accept(this, this.context());
    }

    public abstract ResourceLocation name();

    public abstract BiomeContext context();

    public void addFeature(GenerationStage.Decoration decoration, ConfiguredFeature<?, ?> feature, boolean condition) {
        if (condition) {
            this.addFeature(decoration, feature);
        }
    }

    public void removeFeature(GenerationStage.Decoration decoration, ConfiguredFeature<?, ?> feature, boolean condition) {
        if (condition) {
            this.removeFeature(decoration, feature);
        }
    }

    public abstract void addFeature(GenerationStage.Decoration var1, ConfiguredFeature<?, ?> var2);

    public abstract void removeFeature(GenerationStage.Decoration var1, ConfiguredFeature<?, ?> var2);

    public void replaceFeature(GenerationStage.Decoration decoration, ConfiguredFeature<?, ?> replacement, ConfiguredFeature<?, ?> feature) {
        if (this.context().hasFeature(feature)) {
            this.addFeature(decoration, replacement);
            this.removeFeature(decoration, feature);
        }
    }

    public void addStructure(StructureFeature<?, ?> structure, boolean condition) {
        if (condition) {
            this.addStructure(structure);
        }
    }

    public void removeStructure(StructureFeature<?, ?> structure, boolean condition) {
        if (condition) {
            this.removeStructure(structure);
        }
    }

    public abstract void addStructure(StructureFeature<?, ?> var1);

    public abstract void removeStructure(StructureFeature<?, ?> var1);

    public void addCarver(GenerationStage.Carving carving, ConfiguredCarver<?> carver, boolean condition) {
        if (condition) {
            this.addCarver(carving, carver);
        }
    }

    public void removeCarver(GenerationStage.Carving carving, ConfiguredCarver<?> carver, boolean condition) {
        if (condition) {
            this.removeCarver(carving, carver);
        }
    }

    public abstract void addCarver(GenerationStage.Carving var1, ConfiguredCarver<?> var2);

    public abstract void removeCarver(GenerationStage.Carving var1, ConfiguredCarver<?> var2);

    public abstract void addSurface(ConfiguredSurfaceBuilder<?> var1);

    public void addSpawn(EntityClassification category, MobSpawnInfo.Spawners data, boolean condition) {
        if (condition) {
            this.addSpawn(category, data);
        }
    }

    public void removeSpawn(EntityType<?> entity, boolean condition) {
        if (condition) {
            this.removeSpawn(entity);
        }
    }

    public abstract void addSpawn(EntityClassification var1, MobSpawnInfo.Spawners var2);

    public abstract void removeSpawn(EntityType<?> var1);

    public void replaceSpawn(EntityClassification category, MobSpawnInfo.Spawners data) {
        if (this.context().hasEntity(() -> data.field_242588_c)) {
            this.removeSpawn(data.field_242588_c);
            this.addSpawn(category, data);
        }
    }
}

