/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.common.worldgen.modifier.forge;

import com.blackgear.platform.common.worldgen.modifier.BiomeContext;
import com.blackgear.platform.common.worldgen.modifier.BiomeManager;
import com.blackgear.platform.common.worldgen.modifier.BiomeWriter;
import com.blackgear.platform.core.util.ExtraCodecs;
import java.util.function.Predicate;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.carver.ConfiguredCarver;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="platform", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class BiomeManagerImpl {
    public static void bootstrap() {
    }

    @SubscribeEvent
    public static void onBiomeLoad(BiomeLoadingEvent event) {
        BiomeManager.INSTANCE.register(new ForgeBiomeWriter(event));
    }

    static class ForgeBiomeWriter
    extends BiomeWriter {
        private final BiomeLoadingEvent event;

        ForgeBiomeWriter(BiomeLoadingEvent event) {
            this.event = event;
        }

        @Override
        public ResourceLocation name() {
            return this.event.getName();
        }

        @Override
        public BiomeContext context() {
            return new BiomeContext(){

                @Override
                public RegistryKey<Biome> key() {
                    return RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)this.name());
                }

                @Override
                public Biome biome() {
                    return (Biome)ForgeRegistries.BIOMES.getValue(event.getName());
                }

                @Override
                public boolean is(Biome.Category category) {
                    return event.getCategory() == category;
                }

                @Override
                public boolean is(RegistryKey<Biome> biome) {
                    return this.key() == biome;
                }

                @Override
                public boolean is(Predicate<BiomeContext> context) {
                    return context.test(this);
                }

                @Override
                public boolean hasFeature(ConfiguredFeature<?, ?> feature) {
                    for (GenerationStage.Decoration decoration : GenerationStage.Decoration.values()) {
                        if (!event.getGeneration().getFeatures(decoration).stream().anyMatch(supplier -> ExtraCodecs.serializeAndCompareFeature((ConfiguredFeature)supplier.get(), feature))) continue;
                        return true;
                    }
                    return false;
                }
            };
        }

        @Override
        public void addFeature(GenerationStage.Decoration decoration, ConfiguredFeature<?, ?> feature) {
            this.event.getGeneration().func_242513_a(decoration, feature);
        }

        @Override
        public void removeFeature(GenerationStage.Decoration decoration, ConfiguredFeature<?, ?> feature) {
            this.event.getGeneration().getFeatures(decoration).removeIf(supplier -> ExtraCodecs.serializeAndCompareFeature((ConfiguredFeature)supplier.get(), feature));
        }

        @Override
        public void addStructure(StructureFeature<?, ?> structure) {
            this.event.getGeneration().func_242516_a(structure);
        }

        @Override
        public void removeStructure(StructureFeature<?, ?> structure) {
            this.event.getGeneration().getStructures().removeIf(supplier -> ExtraCodecs.serializeAndCompareStructure((StructureFeature)supplier.get(), structure));
        }

        @Override
        public void addCarver(GenerationStage.Carving carving, ConfiguredCarver<?> carver) {
            this.event.getGeneration().func_242512_a(carving, carver);
        }

        @Override
        public void removeCarver(GenerationStage.Carving carving, ConfiguredCarver<?> carver) {
            this.event.getGeneration().getCarvers(carving).removeIf(supplier -> ExtraCodecs.serializeAndCompareCarver((ConfiguredCarver)supplier.get(), carver));
        }

        @Override
        public void addSurface(ConfiguredSurfaceBuilder<?> surface) {
            this.event.getGeneration().func_242517_a(surface);
        }

        @Override
        public void addSpawn(EntityClassification category, MobSpawnInfo.Spawners data) {
            this.event.getSpawns().func_242575_a(category, data);
        }

        @Override
        public void removeSpawn(EntityType<?> entity) {
            this.event.getSpawns().getSpawner(entity.func_220339_d()).removeIf(spawner -> spawner.field_242588_c == entity);
        }
    }
}

