/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.common.worldgen.noise;

import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;

public class NoiseInterpolator {
    private double[][] slice0;
    private double[][] slice1;
    private final int cellCountY;
    private final int cellCountZ;
    private final int cellMinY;
    private final NoiseColumnFiller noiseColumnFiller;
    private double noise000;
    private double noise001;
    private double noise100;
    private double noise101;
    private double noise010;
    private double noise011;
    private double noise110;
    private double noise111;
    private double valueXZ00;
    private double valueXZ10;
    private double valueXZ01;
    private double valueXZ11;
    private double valueZ0;
    private double valueZ1;
    private final int firstCellXInChunk;
    private final int firstCellZInChunk;

    public NoiseInterpolator(int cellCountX, int cellCountY, int cellCountZ, ChunkPos chunkPos, int cellMinY, NoiseColumnFiller filler) {
        this.cellCountY = cellCountY;
        this.cellCountZ = cellCountZ;
        this.cellMinY = cellMinY;
        this.noiseColumnFiller = filler;
        this.slice0 = NoiseInterpolator.allocateSlice(cellCountY, cellCountZ);
        this.slice1 = NoiseInterpolator.allocateSlice(cellCountY, cellCountZ);
        this.firstCellXInChunk = chunkPos.field_77276_a * cellCountX;
        this.firstCellZInChunk = chunkPos.field_77275_b * cellCountZ;
    }

    private static double[][] allocateSlice(int cellCountY, int cellCountZ) {
        int noiseZ = cellCountZ + 1;
        int noiseY = cellCountY + 1;
        double[][] buffer = new double[noiseZ][noiseY];
        for (int i = 0; i < noiseZ; ++i) {
            buffer[i] = new double[noiseY];
        }
        return buffer;
    }

    public void initializeForFirstCellX() {
        this.fillSlice(this.slice0, this.firstCellXInChunk);
    }

    public void advanceCellX(int i) {
        this.fillSlice(this.slice1, this.firstCellXInChunk + i + 1);
    }

    private void fillSlice(double[][] slice, int x) {
        for (int cellZ = 0; cellZ < this.cellCountZ + 1; ++cellZ) {
            int z = this.firstCellZInChunk + cellZ;
            this.noiseColumnFiller.fillNoiseColumn(slice[cellZ], x, z, this.cellMinY, this.cellCountY);
        }
    }

    public void selectCellYZ(int cellCountY, int cellCountZ) {
        this.noise000 = this.slice0[cellCountZ][cellCountY];
        this.noise001 = this.slice0[cellCountZ + 1][cellCountY];
        this.noise100 = this.slice1[cellCountZ][cellCountY];
        this.noise101 = this.slice1[cellCountZ + 1][cellCountY];
        this.noise010 = this.slice0[cellCountZ][cellCountY + 1];
        this.noise011 = this.slice0[cellCountZ + 1][cellCountY + 1];
        this.noise110 = this.slice1[cellCountZ][cellCountY + 1];
        this.noise111 = this.slice1[cellCountZ + 1][cellCountY + 1];
    }

    public void updateForY(double factorY) {
        this.valueXZ00 = MathHelper.func_219803_d((double)factorY, (double)this.noise000, (double)this.noise010);
        this.valueXZ10 = MathHelper.func_219803_d((double)factorY, (double)this.noise100, (double)this.noise110);
        this.valueXZ01 = MathHelper.func_219803_d((double)factorY, (double)this.noise001, (double)this.noise011);
        this.valueXZ11 = MathHelper.func_219803_d((double)factorY, (double)this.noise101, (double)this.noise111);
    }

    public void updateForX(double factorX) {
        this.valueZ0 = MathHelper.func_219803_d((double)factorX, (double)this.valueXZ00, (double)this.valueXZ10);
        this.valueZ1 = MathHelper.func_219803_d((double)factorX, (double)this.valueXZ01, (double)this.valueXZ11);
    }

    public double calculateValue(double factorZ) {
        return MathHelper.func_219803_d((double)factorZ, (double)this.valueZ0, (double)this.valueZ1);
    }

    public void swapSlices() {
        double[][] slice = this.slice0;
        this.slice0 = this.slice1;
        this.slice1 = slice;
    }

    @FunctionalInterface
    public static interface NoiseColumnFiller {
        public void fillNoiseColumn(double[] var1, int var2, int var3, int var4, int var5);
    }
}

