/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.core;

import com.blackgear.platform.core.forge.CoreRegistryImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;

public abstract class CoreRegistry<T> {
    protected final String modId;
    protected boolean isPresent = false;
    protected final Set<Supplier<T>> entries = new HashSet<Supplier<T>>();

    protected CoreRegistry(String modId) {
        this.modId = modId;
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T> CoreRegistry<T> create(RegistryKey<? extends Registry<T>> key, String modId) {
        void var1_1;
        return CoreRegistryImpl.create(key, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T> CoreRegistry<T> create(Registry<T> registry, String modId) {
        void var1_1;
        return CoreRegistryImpl.create(registry, (String)var1_1);
    }

    public abstract <E extends T> Supplier<E> register(String var1, Supplier<E> var2);

    public abstract <E extends T> E vanilla(String var1, E var2);

    public <E extends T> RegistryKey<T> resource(String name, Supplier<E> entry) {
        this.register(name, entry);
        return RegistryKey.func_240903_a_(this.key(), (ResourceLocation)new ResourceLocation(this.modId, name));
    }

    public <E extends T> RegistryKey<T> vanillaResource(String name, E entry) {
        this.vanilla(name, entry);
        return RegistryKey.func_240903_a_(this.key(), (ResourceLocation)new ResourceLocation(this.modId, name));
    }

    public Collection<Supplier<T>> entries() {
        return Collections.unmodifiableSet(this.entries);
    }

    public abstract RegistryKey<? extends Registry<T>> key();

    public abstract Registry<T> registry();

    public String modId() {
        return this.modId;
    }

    public void register() {
        if (this.isPresent) {
            throw new IllegalArgumentException("Duplication of Registry: " + this.key());
        }
        this.isPresent = true;
        this.bootstrap();
    }

    protected abstract void bootstrap();

    public static class FabricatedRegistry<T>
    extends CoreRegistry<T> {
        private final Registry<T> registry;

        public FabricatedRegistry(Registry<T> registry, String modId) {
            super(modId);
            this.registry = registry;
        }

        public static <T> CoreRegistry<T> create(RegistryKey<? extends Registry<T>> key, String modId) {
            Registry registry = (Registry)Registry.field_212617_f.func_82594_a(key.func_240901_a_());
            if (registry == null) {
                throw new IllegalArgumentException("Unknown registry: " + key.func_240901_a_());
            }
            return new FabricatedRegistry<T>(registry, modId);
        }

        public static <T> CoreRegistry<T> create(Registry<T> registry, String modId) {
            return new FabricatedRegistry<T>(registry, modId);
        }

        @Override
        public <E extends T> Supplier<E> register(String name, Supplier<E> entry) {
            Object value = Registry.func_218322_a(this.registry, (ResourceLocation)new ResourceLocation(this.modId, name), entry.get());
            this.entries.add(() -> value);
            return () -> value;
        }

        @Override
        public <E extends T> E vanilla(String name, E entry) {
            Object value = Registry.func_218322_a(this.registry, (ResourceLocation)new ResourceLocation(this.modId, name), entry);
            this.entries.add(() -> value);
            return (E)value;
        }

        @Override
        public RegistryKey<? extends Registry<T>> key() {
            return this.registry.func_243578_f();
        }

        @Override
        public Registry<T> registry() {
            return this.registry;
        }

        @Override
        protected void bootstrap() {
        }
    }
}

