/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.core;

import com.blackgear.platform.core.forge.EnvironmentImpl;
import com.blackgear.platform.core.util.config.ConfigBuilder;
import com.blackgear.platform.core.util.config.IConfigSpec;
import com.blackgear.platform.core.util.config.ModConfig;
import com.blackgear.platform.core.util.config.SimpleConfigBuilder;
import com.blackgear.platform.core.util.config.SimpleConfigSpec;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.concurrent.ThreadTaskExecutor;
import org.apache.commons.lang3.tuple.Pair;

public final class Environment {
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isClientSide() {
        return EnvironmentImpl.isClientSide();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isProduction() {
        return EnvironmentImpl.isProduction();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean hasModLoaded(String modId) {
        return EnvironmentImpl.hasModLoaded(modId);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static String getModVersion(String modId) {
        return EnvironmentImpl.getModVersion(modId);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Optional<MinecraftServer> getCurrentServer() {
        return EnvironmentImpl.getCurrentServer();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ThreadTaskExecutor<?> getGameExecutor() {
        return EnvironmentImpl.getGameExecutor();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Path getGameDir() {
        return EnvironmentImpl.getGameDir();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Path getConfigDir() {
        return EnvironmentImpl.getConfigDir();
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T> T registerSafeConfig(String modId, ModConfig.Type type, Function<ConfigBuilder, T> spec) {
        void var2_2;
        void var1_1;
        return EnvironmentImpl.registerSafeConfig(modId, (ModConfig.Type)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T> T registerSafeConfig(String modId, ModConfig.Type type, String fileName, Function<ConfigBuilder, T> spec) {
        void var3_3;
        void var2_2;
        void var1_1;
        return EnvironmentImpl.registerSafeConfig(modId, (ModConfig.Type)var1_1, (String)var2_2, var3_3);
    }

    public static <T> T registerUnsafeConfig(String modId, ModConfig.Type type, Function<ConfigBuilder, T> spec) {
        Pair<T, SimpleConfigSpec> pair = new SimpleConfigBuilder().configure(spec);
        new ModConfig(type, (IConfigSpec)pair.getRight(), modId);
        return (T)pair.getLeft();
    }

    public static <T> T registerUnsafeConfig(String modId, ModConfig.Type type, String fileName, Function<ConfigBuilder, T> spec) {
        Pair<T, SimpleConfigSpec> pair = new SimpleConfigBuilder().configure(spec);
        new ModConfig(type, (IConfigSpec)pair.getRight(), modId, fileName);
        return (T)pair.getLeft();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Loader getLoader() {
        return EnvironmentImpl.getLoader();
    }

    public static boolean isForge() {
        return Environment.getLoader() == Loader.FORGE;
    }

    public static boolean isFabric() {
        return Environment.getLoader() == Loader.FABRIC;
    }

    public static enum Loader {
        FORGE,
        FABRIC;

    }
}

