/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.core;

import com.blackgear.platform.core.ParallelDispatch;
import com.blackgear.platform.core.forge.ModInstanceBuilderImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.function.Consumer;

public abstract class ModInstance {
    public final String modId;
    public Runnable onCommon;
    public Consumer<ParallelDispatch> onPostCommon;
    public Runnable onClient;
    public Consumer<ParallelDispatch> onPostClient;

    public ModInstance(String modId, Runnable onCommon, Consumer<ParallelDispatch> onPostCommon, Runnable onClient, Consumer<ParallelDispatch> onPostClient) {
        this.modId = modId;
        this.onCommon = onCommon;
        this.onPostCommon = onPostCommon;
        this.onClient = onClient;
        this.onPostClient = onPostClient;
        this.populateIfEmpty();
    }

    public static Builder create(String modId) {
        return new Builder(modId);
    }

    public abstract void bootstrap();

    private void commonSetup(Runnable common) {
        this.onCommon = common;
    }

    private void postCommonSetup(Consumer<ParallelDispatch> common) {
        this.onPostCommon = common;
    }

    private void clientSetup(Runnable client) {
        this.onClient = client;
    }

    private void postClientSetup(Consumer<ParallelDispatch> client) {
        this.onPostClient = client;
    }

    private void populateIfEmpty() {
        if (this.onCommon == null) {
            this.commonSetup(() -> {});
        }
        if (this.onPostCommon == null) {
            this.postCommonSetup(dispatch -> {});
        }
        if (this.onClient == null) {
            this.clientSetup(() -> {});
        }
        if (this.onPostClient == null) {
            this.postClientSetup(dispatch -> {});
        }
    }

    public static class Builder {
        private final String modId;
        private Runnable onCommon;
        private Consumer<ParallelDispatch> onPostCommon;
        private Runnable onClient;
        private Consumer<ParallelDispatch> onPostClient;

        protected Builder(String modId) {
            this.modId = modId;
        }

        public Builder common(Runnable common) {
            this.onCommon = common;
            return this;
        }

        public Builder postCommon(Consumer<ParallelDispatch> common) {
            this.onPostCommon = common;
            return this;
        }

        public Builder client(Runnable client) {
            this.onClient = client;
            return this;
        }

        public Builder postClient(Consumer<ParallelDispatch> client) {
            this.onPostClient = client;
            return this;
        }

        public ModInstance build() {
            return Builder.builder(this.modId, this.onCommon, this.onPostCommon, this.onClient, this.onPostClient);
        }

        /*
         * WARNING - void declaration
         */
        @ExpectPlatform
        @ExpectPlatform.Transformed
        public static ModInstance builder(String modId, Runnable common, Consumer<ParallelDispatch> postCommon, Runnable client, Consumer<ParallelDispatch> postClient) {
            void var4_4;
            void var3_3;
            void var2_2;
            void var1_1;
            return ModInstanceBuilderImpl.builder(modId, (Runnable)var1_1, (Consumer<ParallelDispatch>)var2_2, (Runnable)var3_3, (Consumer<ParallelDispatch>)var4_4);
        }
    }
}

