/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.core;

import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;

public final class RegistryBuilder {
    private final String modId;

    public RegistryBuilder(String modId) {
        this.modId = modId;
    }

    public <T> RegistryKey<Registry<T>> resource(String name) {
        return RegistryKey.func_240904_a_((ResourceLocation)new ResourceLocation(this.modId, name));
    }

    public <T> Registry<T> registry(RegistryKey<Registry<T>> key, Supplier<T> bootstrap) {
        return Registry.func_239746_a_(key, bootstrap);
    }

    public <T> RegistryReference<T> create(String name, Supplier<T> bootstrap) {
        Objects.requireNonNull(name, "Registry name cannot be null");
        Objects.requireNonNull(bootstrap, "Bootstrap function cannot be null");
        RegistryKey<Registry<T>> resource = this.resource(name);
        return new RegistryReference<T>(resource, this.registry(resource, bootstrap));
    }

    public void bootstrap() {
    }

    public static class RegistryReference<T> {
        private final RegistryKey<Registry<T>> resource;
        private final Registry<T> registry;

        public RegistryReference(RegistryKey<Registry<T>> resource, Registry<T> registry) {
            this.resource = resource;
            this.registry = registry;
        }

        public RegistryKey<Registry<T>> getResource() {
            return this.resource;
        }

        public Registry<T> getRegistry() {
            return this.registry;
        }

        public ResourceLocation location() {
            return this.resource.func_240901_a_();
        }
    }
}

