/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.core.forge;

import com.blackgear.platform.core.CoreRegistry;
import java.util.function.Supplier;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryManager;

public class CoreRegistryImpl<T extends IForgeRegistryEntry<T>>
extends CoreRegistry<T> {
    private final DeferredRegister<T> registry;
    private final RegistryKey<? extends Registry<T>> resourceKey;

    protected CoreRegistryImpl(IForgeRegistry<T> entry, RegistryKey<? extends Registry<T>> resourceKey, String modId) {
        super(modId);
        this.resourceKey = resourceKey;
        this.registry = DeferredRegister.create(entry, (String)modId);
    }

    public static <T> CoreRegistry<T> create(RegistryKey<? extends Registry<T>> key, String modId) {
        ForgeRegistry entry = RegistryManager.ACTIVE.getRegistry(key);
        return entry != null ? new CoreRegistryImpl<T>(entry, key, modId) : CoreRegistry.FabricatedRegistry.create(key, modId);
    }

    public static <T> CoreRegistry<T> create(Registry<T> registry, String modId) {
        ForgeRegistry entry = RegistryManager.ACTIVE.getRegistry(registry.func_243578_f());
        return entry != null ? new CoreRegistryImpl<T>(entry, registry.func_243578_f(), modId) : CoreRegistry.FabricatedRegistry.create(registry, modId);
    }

    @Override
    public <E extends T> Supplier<E> register(String name, Supplier<E> entry) {
        RegistryObject value = this.registry.register(name, entry);
        this.entries.add(value);
        return value;
    }

    @Override
    public <E extends T> E vanilla(String name, E entry) {
        RegistryObject value = this.registry.register(name, () -> entry);
        this.entries.add(value);
        return entry;
    }

    @Override
    public RegistryKey<? extends Registry<T>> key() {
        return this.resourceKey;
    }

    @Override
    public Registry<T> registry() {
        return (Registry)CoreRegistryImpl.get(this.key());
    }

    private static <T> T get(RegistryKey<?> key) {
        return (T)Registry.field_212617_f.func_230516_a_(key);
    }

    @Override
    protected void bootstrap() {
        this.registry.register(FMLJavaModLoadingContext.get().getModEventBus());
    }
}

