/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.core.helper;

import com.mojang.datafixers.types.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;

public class BlockEntityTypeBuilder<T extends TileEntity> {
    private final Supplier<? extends T> factory;
    private final List<Supplier<Block>> blocks;

    private BlockEntityTypeBuilder(Supplier<? extends T> factory, List<Supplier<Block>> blocks) {
        this.factory = factory;
        this.blocks = blocks;
    }

    public static <T extends TileEntity> BlockEntityTypeBuilder<T> create(Supplier<? extends T> factory, List<Supplier<Block>> blocks) {
        return new BlockEntityTypeBuilder<T>(factory, blocks);
    }

    @SafeVarargs
    public static <T extends TileEntity> BlockEntityTypeBuilder<T> create(Supplier<? extends T> factory, Supplier<Block> ... blocks) {
        ArrayList<Supplier<Block>> entries = new ArrayList<Supplier<Block>>(blocks.length);
        Collections.addAll(entries, blocks);
        return new BlockEntityTypeBuilder<T>(factory, entries);
    }

    public BlockEntityTypeBuilder<T> add(Supplier<Block> block) {
        this.blocks.add(block);
        return this;
    }

    @SafeVarargs
    public final BlockEntityTypeBuilder<T> add(Supplier<Block> ... block) {
        Collections.addAll(this.blocks, block);
        return this;
    }

    public TileEntityType<T> build() {
        return this.build(null);
    }

    public TileEntityType<T> build(Type<?> type) {
        return TileEntityType.Builder.func_223042_a(this.factory, (Block[])((Block[])this.blocks.stream().map(Supplier::get).toArray(Block[]::new))).func_206865_a(type);
    }
}

