/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.core.helper;

import com.blackgear.platform.common.block.BlockProperties;
import com.blackgear.platform.core.CoreRegistry;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.util.registry.Registry;

public class BlockRegistry {
    private final CoreRegistry<Block> blocks;
    private final CoreRegistry<Item> items;

    private BlockRegistry(String modId) {
        this.blocks = CoreRegistry.create(Registry.field_212618_g, modId);
        this.items = CoreRegistry.create(Registry.field_212630_s, modId);
    }

    public static BlockRegistry create(String modId) {
        return new BlockRegistry(modId);
    }

    public Supplier<Block> register(String name, Function<AbstractBlock.Properties, Block> blockFactory, BlockProperties.Builder blockProperties, BiFunction<Block, Item.Properties, Item> itemFactory, Item.Properties itemProperties) {
        return this.register(name, blockFactory, blockProperties, name, itemFactory, itemProperties);
    }

    public Supplier<Block> register(String name, Function<AbstractBlock.Properties, Block> blockFactory, AbstractBlock.Properties blockProperties, BiFunction<Block, Item.Properties, Item> itemFactory, Item.Properties itemProperties) {
        return this.register(name, blockFactory, blockProperties, name, itemFactory, itemProperties);
    }

    public Supplier<Block> register(String blockName, Function<AbstractBlock.Properties, Block> blockFactory, BlockProperties.Builder blockProperties, String itemName, BiFunction<Block, Item.Properties, Item> itemFactory, Item.Properties itemProperties) {
        return this.register(blockName, blockFactory, blockProperties.build(), itemName, itemFactory, itemProperties);
    }

    public Supplier<Block> register(String blockName, Function<AbstractBlock.Properties, Block> blockFactory, AbstractBlock.Properties blockProperties, String itemName, BiFunction<Block, Item.Properties, Item> itemFactory, Item.Properties itemProperties) {
        Supplier<Block> block = this.registerNoItem(blockName, blockFactory, blockProperties);
        this.items.register(itemName, () -> (Item)itemFactory.apply((Block)block.get(), itemProperties));
        return block;
    }

    public Supplier<Block> register(String blockName, Function<AbstractBlock.Properties, Block> factory, BlockProperties.Builder properties, String itemName, Function<Supplier<Block>, Item> item) {
        Supplier<Block> entry = this.registerNoItem(blockName, factory, properties);
        this.items.register(itemName, () -> (Item)item.apply(entry));
        return entry;
    }

    public Supplier<Block> register(String blockName, Supplier<Block> block, String itemName, Function<Supplier<Block>, Item> item) {
        Supplier<Block> entry = this.registerNoItem(blockName, block);
        this.items.register(itemName, () -> (Item)item.apply(entry));
        return entry;
    }

    public Supplier<Block> register(String name, Supplier<Block> block, Function<Supplier<Block>, Item> item) {
        Supplier<Block> entry = this.registerNoItem(name, block);
        this.items.register(name, () -> (Item)item.apply(entry));
        return entry;
    }

    public Supplier<Block> register(String name, BlockProperties.Builder builder) {
        return this.register(name, () -> new Block(builder.build()));
    }

    public Supplier<Block> register(String name, AbstractBlock.Properties properties) {
        return this.register(name, () -> new Block(properties));
    }

    public Supplier<Block> register(String name, Function<AbstractBlock.Properties, Block> factory, BlockProperties.Builder builder) {
        return this.register(name, factory, builder.build());
    }

    public Supplier<Block> register(String name, Function<AbstractBlock.Properties, Block> factory, AbstractBlock.Properties properties) {
        return this.register(name, () -> (Block)factory.apply(properties));
    }

    public Supplier<Block> register(String name, Supplier<Block> block) {
        return this.register(name, block, (Supplier<Block> entry) -> new BlockItem((Block)entry.get(), new Item.Properties()));
    }

    public Supplier<Block> registerNoItem(String name, BlockProperties.Builder builder) {
        return this.registerNoItem(name, () -> new Block(builder.build()));
    }

    public Supplier<Block> registerNoItem(String name, AbstractBlock.Properties properties) {
        return this.registerNoItem(name, () -> new Block(properties));
    }

    public Supplier<Block> registerNoItem(String name, Function<AbstractBlock.Properties, Block> factory, BlockProperties.Builder builder) {
        return this.registerNoItem(name, factory, builder.build());
    }

    public Supplier<Block> registerNoItem(String name, Function<AbstractBlock.Properties, Block> factory, AbstractBlock.Properties properties) {
        return this.registerNoItem(name, () -> (Block)factory.apply(properties));
    }

    public Supplier<Block> registerNoItem(String name, Supplier<Block> block) {
        return this.blocks.register(name, block);
    }

    public void register() {
        this.blocks.register();
        this.items.register();
    }
}

