/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.core.helper;

import com.blackgear.platform.core.util.FriendlyByteBufUtils;
import java.util.Optional;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.IObjectIntIterable;

public class DataSerializerRegistry {
    public static DataSerializerRegistry create() {
        return new DataSerializerRegistry();
    }

    public <T> IDataSerializer<T> simple(final FriendlyByteBufUtils.Writer<T> writer, final FriendlyByteBufUtils.Reader<T> reader) {
        return this.register(new ForValueType<T>(){

            public void func_187160_a(PacketBuffer buffer, T value) {
                writer.accept(buffer, value);
            }

            public T func_187159_a(PacketBuffer buffer) {
                return reader.apply(buffer);
            }
        });
    }

    public <T> IDataSerializer<Optional<T>> optional(FriendlyByteBufUtils.Writer<T> writer, FriendlyByteBufUtils.Reader<T> reader) {
        return this.simple(writer.asOptional(), reader.asOptional());
    }

    public <T extends Enum<T>> IDataSerializer<T> simpleEnum(Class<T> clazz) {
        return this.simple(PacketBuffer::func_179249_a, buf -> buf.func_179257_a(clazz));
    }

    public <T> IDataSerializer<T> simpleId(IObjectIntIterable<T> idMap) {
        return this.simple((buf, arg) -> FriendlyByteBufUtils.writeId(buf, idMap, arg), buf -> FriendlyByteBufUtils.readById(buf, idMap));
    }

    public <T> IDataSerializer<T> register(IDataSerializer<T> serializer) {
        DataSerializers.func_187189_a(serializer);
        return serializer;
    }

    public void register() {
    }

    private static interface ForValueType<T>
    extends IDataSerializer<T> {
        default public T func_192717_a(T value) {
            return value;
        }
    }
}

