/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.core.helper;

import com.blackgear.platform.core.CoreRegistry;
import com.blackgear.platform.core.mixin.access.ActivityAccessor;
import com.blackgear.platform.core.mixin.access.MemoryModuleTypeAccessor;
import com.blackgear.platform.core.mixin.access.SensorTypeAccessor;
import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.schedule.Activity;
import net.minecraft.entity.ai.brain.sensor.Sensor;
import net.minecraft.entity.ai.brain.sensor.SensorType;
import net.minecraft.util.registry.Registry;

public class EntityRegistry {
    private final CoreRegistry<EntityType<?>> entities;
    private final CoreRegistry<Activity> activities;
    private final CoreRegistry<SensorType<?>> sensors;
    private final CoreRegistry<MemoryModuleType<?>> memories;

    public static EntityRegistry create(String modId) {
        return new EntityRegistry(modId);
    }

    private EntityRegistry(String modId) {
        this.entities = CoreRegistry.create(Registry.field_212629_r, modId);
        this.activities = CoreRegistry.create(Registry.field_218375_Q, modId);
        this.sensors = CoreRegistry.create(Registry.field_218373_O, modId);
        this.memories = CoreRegistry.create(Registry.field_218372_N, modId);
    }

    public <T extends Entity> Supplier<EntityType<T>> entity(String name, EntityType.Builder<T> entity) {
        return this.entities.register(name, () -> entity.func_206830_a(name));
    }

    public Supplier<Activity> activity(String name) {
        return this.activities.register(name, () -> ActivityAccessor.createActivity(name));
    }

    public <T extends Sensor<?>> Supplier<SensorType<T>> sensor(String name, Supplier<T> supplier) {
        return this.sensors.register(name, () -> SensorTypeAccessor.createSensorType(supplier));
    }

    public <T> Supplier<MemoryModuleType<T>> memory(String name, Codec<T> codec) {
        return this.memories.register(name, () -> MemoryModuleTypeAccessor.createMemoryModuleType(Optional.of(codec)));
    }

    public <T> Supplier<MemoryModuleType<T>> memory(String name) {
        return this.memories.register(name, () -> MemoryModuleTypeAccessor.createMemoryModuleType(Optional.empty()));
    }

    public void register() {
        this.entities.register();
        this.activities.register();
        this.sensors.register();
        this.memories.register();
    }
}

