/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.core.helper;

import com.blackgear.platform.core.CoreRegistry;
import com.blackgear.platform.core.helper.forge.ItemRegistryImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.item.Item;
import net.minecraft.util.registry.Registry;

public class ItemRegistry {
    private final CoreRegistry<Item> items;

    private ItemRegistry(String modId) {
        this.items = CoreRegistry.create(Registry.field_212630_s, modId);
    }

    public static ItemRegistry create(String modId) {
        return new ItemRegistry(modId);
    }

    public <T extends Item> Supplier<T> register(String name, Supplier<T> item) {
        return this.items.register(name, item);
    }

    public Supplier<Item> register(String name) {
        return this.register(name, new Item.Properties());
    }

    public Supplier<Item> register(String name, Item.Properties properties) {
        return this.register(name, Item::new, properties);
    }

    public Supplier<Item> register(String name, Function<Item.Properties, Item> factory) {
        return this.register(name, factory, new Item.Properties());
    }

    public Supplier<Item> register(String name, Function<Item.Properties, Item> factory, Item.Properties properties) {
        return this.items.register(name, () -> (Item)factory.apply(properties));
    }

    public <T extends MobEntity> Supplier<Item> spawnEgg(String name, Supplier<EntityType<T>> entity, int primaryColor, int secondaryColor, Item.Properties properties) {
        return this.items.register(name, () -> ItemRegistry.createSpawnEgg(entity, primaryColor, secondaryColor, properties));
    }

    public Supplier<Item> fromBlock(Supplier<Block> block) {
        return () -> ((Block)block.get()).func_199767_j();
    }

    public void register() {
        this.items.register();
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T extends MobEntity> Item createSpawnEgg(Supplier<EntityType<T>> entity, int primaryColor, int secondaryColor, Item.Properties properties) {
        void var3_3;
        void var2_2;
        void var1_1;
        return ItemRegistryImpl.createSpawnEgg(entity, (int)var1_1, (int)var2_2, (Item.Properties)var3_3);
    }
}

