/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.core.helper;

import com.blackgear.platform.core.CoreRegistry;
import java.util.function.Supplier;
import net.minecraft.block.SoundType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.registry.Registry;

public class SoundRegistry {
    private final CoreRegistry<SoundEvent> sounds;
    private final String modId;

    public static SoundRegistry create(String modId) {
        return new SoundRegistry(modId);
    }

    private SoundRegistry(String modId) {
        this.modId = modId;
        this.sounds = CoreRegistry.create(Registry.field_212633_v, this.modId);
    }

    public Supplier<SoundEvent> soundEvent(String name) {
        return this.sounds.register(name, () -> new SoundEvent(new ResourceLocation(this.modId, name)));
    }

    public SoundType soundType(float volume, float pitch, Supplier<SoundEvent> breakSound, Supplier<SoundEvent> stepSound, Supplier<SoundEvent> placeSound, Supplier<SoundEvent> hitSound, Supplier<SoundEvent> fallSound) {
        return new SoundTypeImpl(volume, pitch, breakSound, stepSound, placeSound, hitSound, fallSound);
    }

    public SoundType soundType(Supplier<SoundEvent> breakSound, Supplier<SoundEvent> stepSound, Supplier<SoundEvent> placeSound, Supplier<SoundEvent> hitSound, Supplier<SoundEvent> fallSound) {
        return this.soundType(1.0f, 1.0f, breakSound, stepSound, placeSound, hitSound, fallSound);
    }

    public void register() {
        this.sounds.register();
    }

    static class SoundTypeImpl
    extends SoundType {
        private final Supplier<SoundEvent> breakSound;
        private final Supplier<SoundEvent> stepSound;
        private final Supplier<SoundEvent> placeSound;
        private final Supplier<SoundEvent> hitSound;
        private final Supplier<SoundEvent> fallSound;

        public SoundTypeImpl(float volume, float pitch, Supplier<SoundEvent> breakSound, Supplier<SoundEvent> stepSound, Supplier<SoundEvent> placeSound, Supplier<SoundEvent> hitSound, Supplier<SoundEvent> fallSound) {
            super(volume, pitch, null, null, null, null, null);
            this.breakSound = breakSound;
            this.stepSound = stepSound;
            this.placeSound = placeSound;
            this.hitSound = hitSound;
            this.fallSound = fallSound;
        }

        public SoundEvent func_185845_c() {
            return this.breakSound.get();
        }

        public SoundEvent func_185844_d() {
            return this.stepSound.get();
        }

        public SoundEvent func_185841_e() {
            return this.placeSound.get();
        }

        public SoundEvent func_185846_f() {
            return this.hitSound.get();
        }

        public SoundEvent func_185842_g() {
            return this.fallSound.get();
        }
    }
}

