/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.core.mixin.common;

import com.blackgear.platform.common.worldgen.BiomeSpawnPlacement;
import java.util.Optional;
import java.util.function.IntConsumer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeRegistry;
import net.minecraft.world.gen.INoiseRandom;
import net.minecraft.world.gen.layer.EdgeBiomeLayer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EdgeBiomeLayer.class})
public class BiomeEdgeLayerMixin {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Inject(method={"apply"}, at={@At(value="HEAD")}, cancellable=true)
    private void apply(INoiseRandom context, int north, int east, int south, int west, int center, CallbackInfoReturnable<Integer> cir) {
        RegistryKey<Biome> biome = this.fromRawId(center);
        for (BiomeSpawnPlacement.PredicatedBiomeEntry entry : BiomeSpawnPlacement.getPredicatedBorders(biome)) {
            if (!entry.predicate.test(this.fromRawId(north)) && !entry.predicate.test(this.fromRawId(south)) && !entry.predicate.test(this.fromRawId(west)) && !entry.predicate.test(this.fromRawId(east))) continue;
            cir.setReturnValue((Object)this.toRawId(entry.biome));
        }
        if (this.tryReplace(center, north, arg_0 -> cir.setReturnValue(arg_0))) return;
        if (this.tryReplace(center, south, arg_0 -> cir.setReturnValue(arg_0))) return;
        if (this.tryReplace(center, west, arg_0 -> cir.setReturnValue(arg_0))) return;
        if (!this.tryReplace(center, east, arg_0 -> cir.setReturnValue(arg_0))) return;
    }

    @Unique
    private boolean tryReplace(int center, int neighbor, IntConsumer consumer) {
        if (center == neighbor) {
            return false;
        }
        Optional<RegistryKey<Biome>> border = BiomeSpawnPlacement.getBorder(this.fromRawId(neighbor));
        if (border.isPresent()) {
            consumer.accept(this.toRawId(border.get()));
            return true;
        }
        return false;
    }

    @Unique
    private RegistryKey<Biome> fromRawId(int center) {
        return BiomeRegistry.func_244203_a((int)center);
    }

    @Unique
    private int toRawId(RegistryKey<Biome> key) {
        return WorldGenRegistries.field_243657_i.func_148757_b((Object)((Biome)WorldGenRegistries.field_243657_i.func_230516_a_(key)));
    }
}

