/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.core.mixin.forge.core.biome;

import com.blackgear.platform.common.worldgen.biome.InternalBiomeUtils;
import com.blackgear.platform.common.worldgen.parameters.Temperature;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeRegistry;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.INoiseRandom;
import net.minecraft.world.gen.layer.BiomeLayer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BiomeLayer.class})
public class BiomeInitLayerMixin {
    @Shadow
    @Final
    private static int[] field_202744_r;
    @Shadow
    @Final
    private static int[] field_202745_s;
    @Shadow
    @Final
    private static int[] field_202746_t;
    @Shadow
    @Final
    private static int[] field_202747_u;

    @Inject(method={"apply"}, at={@At(value="FIELD", target="Lnet/minecraftforge/common/BiomeManager$BiomeType;DESERT:Lnet/minecraftforge/common/BiomeManager$BiomeType;")}, cancellable=true)
    private void injectHotBiomes(INoiseRandom context, int value, CallbackInfoReturnable<Integer> cir) {
        InternalBiomeUtils.injectBiomesIntoClimate(context, field_202744_r, Temperature.HOT, arg_0 -> cir.setReturnValue(arg_0));
    }

    @Inject(method={"apply"}, at={@At(value="FIELD", target="Lnet/minecraftforge/common/BiomeManager$BiomeType;WARM:Lnet/minecraftforge/common/BiomeManager$BiomeType;")}, cancellable=true)
    private void injectWarmBiomes(INoiseRandom context, int value, CallbackInfoReturnable<Integer> cir) {
        InternalBiomeUtils.injectBiomesIntoClimate(context, field_202745_s, Temperature.WARM, arg_0 -> cir.setReturnValue(arg_0));
    }

    @Inject(method={"apply"}, at={@At(value="FIELD", target="Lnet/minecraftforge/common/BiomeManager$BiomeType;COOL:Lnet/minecraftforge/common/BiomeManager$BiomeType;")}, cancellable=true)
    private void injectCoolBiomes(INoiseRandom context, int value, CallbackInfoReturnable<Integer> cir) {
        InternalBiomeUtils.injectBiomesIntoClimate(context, field_202746_t, Temperature.COOL, arg_0 -> cir.setReturnValue(arg_0));
    }

    @Inject(method={"apply"}, at={@At(value="FIELD", target="Lnet/minecraftforge/common/BiomeManager$BiomeType;ICY:Lnet/minecraftforge/common/BiomeManager$BiomeType;")}, cancellable=true)
    private void injectIcyBiomes(INoiseRandom context, int value, CallbackInfoReturnable<Integer> cir) {
        InternalBiomeUtils.injectBiomesIntoClimate(context, field_202747_u, Temperature.ICY, arg_0 -> cir.setReturnValue(arg_0));
    }

    @Inject(method={"apply"}, at={@At(value="RETURN")}, cancellable=true)
    private void transformVariants(INoiseRandom context, int value, CallbackInfoReturnable<Integer> cir) {
        int biomeId = cir.getReturnValueI();
        RegistryKey biome = BiomeRegistry.func_244203_a((int)biomeId);
        Temperature climate = null;
        if (biome == Biomes.field_150608_ab || biome == Biomes.field_150607_aa) {
            climate = Temperature.HOT;
        } else if (biome == Biomes.field_76782_w || biome == Biomes.field_150578_U) {
            climate = Temperature.WARM;
        }
        cir.setReturnValue((Object)InternalBiomeUtils.transformBiome(context, (RegistryKey<Biome>)biome, climate));
    }
}

