/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.core.mixin.forge.core.biome;

import com.blackgear.platform.common.worldgen.biome.InternalBiomeData;
import com.blackgear.platform.common.worldgen.biome.InternalBiomeUtils;
import com.blackgear.platform.common.worldgen.biome.WeightedBiomePicker;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.biome.BiomeRegistry;
import net.minecraft.world.gen.INoiseRandom;
import net.minecraft.world.gen.area.IArea;
import net.minecraft.world.gen.layer.HillsLayer;
import net.minecraft.world.gen.layer.LayerUtil;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={HillsLayer.class})
public class RegionHillsLayerMixin {
    @Shadow
    @Final
    private static Int2IntMap field_242940_c;

    @Inject(method={"applyPixel"}, at={@At(value="HEAD")}, cancellable=true)
    private void apply(INoiseRandom context, IArea biomeSampler, IArea noiseSampler, int chunkX, int chunkZ, CallbackInfoReturnable<Integer> cir) {
        if (InternalBiomeData.getOverworldHills().isEmpty()) {
            return;
        }
        int biomeId = biomeSampler.func_202678_a(chunkX, chunkZ);
        int noiseSample = noiseSampler.func_202678_a(chunkX, chunkZ);
        int processedNoiseSample = (noiseSample - 2) % 29;
        RegistryKey key = BiomeRegistry.func_244203_a((int)biomeId);
        if (key == null) {
            throw new IllegalStateException("Biome sampler returned unregistered Biome ID: " + biomeId);
        }
        WeightedBiomePicker hillPicker = InternalBiomeData.getOverworldHills().get(key);
        if (hillPicker == null) {
            return;
        }
        if (context.func_202696_a(3) == 0 || processedNoiseSample == 0) {
            int biomeReturn = InternalBiomeUtils.getRawId(hillPicker.pickRandom(context));
            if (processedNoiseSample == 0 && biomeReturn != biomeId) {
                biomeReturn = field_242940_c.getOrDefault(biomeReturn, biomeId);
            }
            if (biomeReturn != biomeId) {
                int similarity = 0;
                if (LayerUtil.func_202826_a((int)biomeSampler.func_202678_a(chunkX, chunkZ - 1), (int)biomeId)) {
                    ++similarity;
                }
                if (LayerUtil.func_202826_a((int)biomeSampler.func_202678_a(chunkX + 1, chunkZ), (int)biomeId)) {
                    ++similarity;
                }
                if (LayerUtil.func_202826_a((int)biomeSampler.func_202678_a(chunkX - 1, chunkZ), (int)biomeId)) {
                    ++similarity;
                }
                if (LayerUtil.func_202826_a((int)biomeSampler.func_202678_a(chunkX, chunkZ + 1), (int)biomeId)) {
                    ++similarity;
                }
                if (similarity >= 3) {
                    cir.setReturnValue((Object)biomeReturn);
                    return;
                }
            }
        }
        cir.setReturnValue((Object)biomeId);
    }
}

