/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.core.mixin.forge.core.biome;

import com.blackgear.platform.common.worldgen.biome.InternalBiomeData;
import com.blackgear.platform.common.worldgen.biome.InternalBiomeUtils;
import java.util.Map;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeRegistry;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.INoiseRandom;
import net.minecraft.world.gen.area.IArea;
import net.minecraft.world.gen.layer.MixRiverLayer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MixRiverLayer.class})
public class RiverMixerLayerMixin {
    @Inject(method={"applyPixel"}, at={@At(value="HEAD")}, cancellable=true)
    private void apply(INoiseRandom context, IArea landSampler, IArea riverSampler, int x, int z, CallbackInfoReturnable<Integer> cir) {
        int landBiomeId = landSampler.func_202678_a(x, z);
        RegistryKey landBiomeKey = BiomeRegistry.func_244203_a((int)landBiomeId);
        int riverBiomeId = riverSampler.func_202678_a(x, z);
        Map<RegistryKey<Biome>, RegistryKey<Biome>> overworldRivers = InternalBiomeData.getOverworldRivers();
        if (overworldRivers.containsKey(landBiomeKey) && BiomeRegistry.func_244203_a((int)riverBiomeId) == Biomes.field_76781_i) {
            RegistryKey<Biome> riverBiome = overworldRivers.get(landBiomeKey);
            cir.setReturnValue((Object)(riverBiome == null ? landBiomeId : InternalBiomeUtils.getRawId(riverBiome)));
        }
    }
}

