/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.core.mixin.forge.core.biome;

import com.blackgear.platform.common.worldgen.biome.InternalBiomeData;
import com.blackgear.platform.common.worldgen.biome.InternalBiomeUtils;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.biome.BiomeRegistry;
import net.minecraft.world.gen.INoiseRandom;
import net.minecraft.world.gen.layer.ShoreLayer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ShoreLayer.class})
public class ShoreLayerMixin {
    @Inject(method={"apply"}, at={@At(value="HEAD")}, cancellable=true)
    private void apply(INoiseRandom context, int north, int east, int south, int west, int center, CallbackInfoReturnable<Integer> cir) {
        RegistryKey centerBiome = BiomeRegistry.func_244203_a((int)center);
        if (InternalBiomeData.getOverworldShores().containsKey(centerBiome) && InternalBiomeUtils.neighborsOcean(north, east, south, west)) {
            cir.setReturnValue((Object)InternalBiomeUtils.getRawId(InternalBiomeData.getOverworldShores().get(centerBiome).pickRandom(context)));
        } else if (InternalBiomeData.getOverworldEdges().containsKey(centerBiome) && InternalBiomeUtils.isEdge(north, east, south, west, center)) {
            cir.setReturnValue((Object)InternalBiomeUtils.getRawId(InternalBiomeData.getOverworldEdges().get(centerBiome).pickRandom(context)));
        }
    }
}

