/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.core.network;

import com.blackgear.platform.core.network.PacketRegistry;
import com.blackgear.platform.core.network.base.NetworkDirection;
import com.blackgear.platform.core.network.base.Packet;
import com.blackgear.platform.core.network.base.PacketHandler;
import java.util.Collection;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerChunkProvider;

public class NetworkChannel {
    private final ResourceLocation channel;

    public NetworkChannel(String modId, int version, String channel) {
        this.channel = new ResourceLocation(modId, channel);
        PacketRegistry.registerChannel(this.channel, version);
    }

    public <T extends Packet<T>> void registerPacket(NetworkDirection direction, ResourceLocation id, PacketHandler<T> handler, Class<T> clazz) {
        if (direction == NetworkDirection.C2S) {
            PacketRegistry.registerC2SPacket(this.channel, id, handler, clazz);
        } else {
            PacketRegistry.registerS2CPacket(this.channel, id, handler, clazz);
        }
    }

    public <T extends Packet<T>> void sendToServer(T packet) {
        PacketRegistry.sendToServer(this.channel, packet);
    }

    public <T extends Packet<T>> void sendToPlayer(T packet, PlayerEntity player) {
        PacketRegistry.sendToPlayer(this.channel, packet, player);
    }

    public <T extends Packet<T>> void sendToPlayers(T packet, Collection<? extends PlayerEntity> players) {
        players.forEach(player -> this.sendToPlayer(packet, (PlayerEntity)player));
    }

    public <T extends Packet<T>> void sendToAllPlayers(T packet, MinecraftServer server) {
        this.sendToPlayers(packet, server.func_184103_al().func_181057_v());
    }

    public <T extends Packet<T>> void sendToPlayersInLevel(T packet, World level) {
        this.sendToPlayers(packet, level.func_217369_A());
    }

    public <T extends Packet<T>> void sendToAllLoadedPlayers(T packet, World level, BlockPos pos) {
        Chunk chunk = level.func_175726_f(pos);
        if (level.func_72863_F() instanceof ServerChunkProvider) {
            ((ServerChunkProvider)level.func_72863_F()).field_217237_a.func_219097_a(chunk.func_76632_l(), false).forEach(player -> this.sendToPlayer(packet, (PlayerEntity)player));
        }
    }

    public <T extends Packet<T>> void sendToPlayersInRange(T packet, World level, BlockPos pos, double range) {
        level.func_217369_A().stream().filter(player -> player.func_233580_cy_().func_177951_i((Vector3i)pos) <= range).forEach(player -> this.sendToPlayer(packet, (PlayerEntity)player));
    }
}

