/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.core.network.forge;

import com.blackgear.platform.core.network.base.NetworkDirection;
import com.blackgear.platform.core.network.base.Packet;
import com.blackgear.platform.core.network.base.PacketHandler;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public class PacketRegistryImpl {
    public static final Map<ResourceLocation, ChannelHolder> CHANNELS = new ConcurrentHashMap<ResourceLocation, ChannelHolder>();

    public static void registerChannel(ResourceLocation name, int version) {
        String protocol = Integer.toString(version);
        ChannelHolder holder = new ChannelHolder(0, NetworkRegistry.newSimpleChannel((ResourceLocation)name, () -> protocol, protocol::equals, protocol::equals));
        CHANNELS.put(name, holder);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static <T extends Packet<T>> void registerS2CPacket(ResourceLocation channel, ResourceLocation id, PacketHandler<T> handler, Class<T> packet) {
        PacketRegistryImpl.registerPacket(channel, handler, packet, NetworkDirection.S2C);
    }

    public static <T extends Packet<T>> void registerC2SPacket(ResourceLocation channel, ResourceLocation id, PacketHandler<T> handler, Class<T> packet) {
        PacketRegistryImpl.registerPacket(channel, handler, packet, NetworkDirection.C2S);
    }

    private static <T extends Packet<T>> void registerPacket(ResourceLocation channel, PacketHandler<T> handler, Class<T> packet, NetworkDirection direction) {
        ChannelHolder holder = PacketRegistryImpl.getChannelHolder(channel);
        holder.value().registerMessage(holder.incrementPackets(), packet, handler::encode, handler::decode, (msg, ctx) -> {
            ((NetworkEvent.Context)ctx.get()).enqueueWork(() -> PacketRegistryImpl.lambda$registerPacket$1(direction, (Supplier)ctx, handler, msg));
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public static <T extends Packet<T>> void sendToServer(ResourceLocation id, T packet) {
        PacketRegistryImpl.getChannelHolder(id).value().sendToServer(packet);
    }

    public static <T extends Packet<T>> void sendToPlayer(ResourceLocation id, T packet, PlayerEntity player) {
        ChannelHolder channel = PacketRegistryImpl.getChannelHolder(id);
        if (player instanceof ServerPlayerEntity) {
            channel.value().send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), packet);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static PlayerEntity getLocalPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    private static ChannelHolder getChannelHolder(ResourceLocation name) {
        return Optional.ofNullable(CHANNELS.get(name)).orElseThrow(() -> new IllegalStateException("Channel not registered: " + name));
    }

    private static /* synthetic */ void lambda$registerPacket$1(NetworkDirection direction, Supplier ctx, PacketHandler handler, Packet msg) {
        ServerPlayerEntity player;
        Object object = direction == NetworkDirection.S2C ? (((NetworkEvent.Context)ctx.get()).getSender() == null ? PacketRegistryImpl.getLocalPlayer() : null) : (player = ((NetworkEvent.Context)ctx.get()).getSender());
        if (player != null) {
            handler.handle(msg).apply((PlayerEntity)player, player.field_70170_p);
        }
    }

    public static class ChannelHolder {
        private int packets;
        private final SimpleChannel channel;

        public ChannelHolder(int packets, SimpleChannel channel) {
            this.packets = packets;
            this.channel = channel;
        }

        public int incrementPackets() {
            return this.packets++;
        }

        public SimpleChannel value() {
            return this.channel;
        }
    }
}

