/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.core.network.packet;

import com.blackgear.platform.Platform;
import com.blackgear.platform.core.network.base.Packet;
import com.blackgear.platform.core.network.base.PacketContext;
import com.blackgear.platform.core.network.base.PacketHandler;
import com.blackgear.platform.core.util.config.ConfigLoader;
import com.blackgear.platform.core.util.config.ConfigTracker;
import com.blackgear.platform.core.util.config.ModConfig;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public class ConfigSyncPacket
implements Packet<ConfigSyncPacket> {
    public static final ResourceLocation ID = Platform.resource("config_sync");
    public static final Handler HANDLER = new Handler();
    private final String name;
    private final byte[] data;

    public ConfigSyncPacket(String name, byte[] data) {
        this.name = name;
        this.data = data;
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public PacketHandler<ConfigSyncPacket> getHandler() {
        return HANDLER;
    }

    public static final class Handler
    implements PacketHandler<ConfigSyncPacket> {
        @Override
        public void encode(ConfigSyncPacket message, PacketBuffer buf) {
            buf.func_180714_a(message.name);
            buf.func_179250_a(message.data);
        }

        @Override
        public ConfigSyncPacket decode(PacketBuffer buf) {
            return new ConfigSyncPacket(buf.func_218666_n(), buf.func_179251_a());
        }

        @Override
        public PacketContext handle(ConfigSyncPacket message) {
            return (player, level) -> {
                ModConfig config = ConfigTracker.INSTANCE.fileMap().get(message.name);
                if (config != null) {
                    config.acceptSyncedConfig(message.data);
                } else {
                    ConfigLoader.LOGGER.error("Received config data for unknown config: {}", (Object)message.name);
                }
            };
        }
    }
}

