/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.core.util;

import com.google.common.collect.ImmutableMap;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;

public final class BlockUtils {
    public static ImmutableMap<BlockState, VoxelShape> getShapeForEachState(Block block, Function<BlockState, VoxelShape> function) {
        return (ImmutableMap)block.func_176194_O().func_177619_a().stream().collect(ImmutableMap.toImmutableMap(Function.identity(), function));
    }

    public static BlockState withPropertiesOf(Block block, BlockState state) {
        BlockState defaultState = block.func_176223_P();
        for (Property property : state.func_177230_c().func_176194_O().func_177623_d()) {
            if (!defaultState.func_235901_b_(property)) continue;
            defaultState = BlockUtils.copyProperty(state, defaultState, property);
        }
        return defaultState;
    }

    public static BlockPos atY(BlockPos pos, int y) {
        return new BlockPos(pos.func_177958_n(), y, pos.func_177952_p());
    }

    private static <T extends Comparable<T>> BlockState copyProperty(BlockState state, BlockState defaultState, Property<T> property) {
        return (BlockState)defaultState.func_206870_a(property, state.func_177229_b(property));
    }

    public static boolean isSourceOfWater(FluidState state) {
        return state.func_206886_c() == Fluids.field_204546_a && state.func_206886_c().func_207193_c(state);
    }

    public static Iterable<BlockPos> randomInCube(Random random, int steps, BlockPos pos, int offset) {
        return BlockPos.func_239585_a_((Random)random, (int)steps, (int)(pos.func_177958_n() - offset), (int)(pos.func_177956_o() - offset), (int)(pos.func_177952_p() - offset), (int)(pos.func_177958_n() + offset), (int)(pos.func_177956_o() + offset), (int)(pos.func_177952_p() + offset));
    }

    public static Optional<BlockPos> getTopConnectedBlock(IBlockReader level, BlockPos pos, Block baseBlock, Direction direction, Block endBlock) {
        BlockState state;
        BlockPos.Mutable mutable = pos.func_239590_i_();
        do {
            mutable.func_189536_c(direction);
        } while ((state = level.func_180495_p((BlockPos)mutable)).func_203425_a(baseBlock));
        return state.func_203425_a(endBlock) ? Optional.of(mutable) : Optional.empty();
    }

    public static boolean isAirOrWater(BlockState state) {
        return state.func_196958_f() || state.func_203425_a(Blocks.field_150355_j);
    }

    public static BlockState copyWaterloggedFrom(IWorldReader level, BlockPos pos, BlockState state) {
        return state.func_235901_b_((Property)BlockStateProperties.field_208198_y) ? (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(level.func_201671_F(pos))) : state;
    }
}

