/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.core.util;

import com.blackgear.platform.core.mixin.access.DirectionAccessor;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.stream.Collector;
import java.util.stream.Stream;
import net.minecraft.entity.Entity;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import org.jetbrains.annotations.Nullable;

public class DirectionUtils {
    public static final Codec<Direction> CODEC = IStringSerializable.func_233023_a_(Direction::values, DirectionUtils::byName);
    public static final Codec<Direction> VERTICAL_CODEC = CODEC.flatXmap(DirectionUtils::verifyVertical, DirectionUtils::verifyVertical);

    @Nullable
    public static Direction byName(@Nullable String name) {
        return name == null ? null : DirectionAccessor.getBY_NAME().get(name.toLowerCase(Locale.ROOT));
    }

    private static DataResult<Direction> verifyVertical(Direction direction) {
        return direction.func_176740_k().func_200128_b() ? DataResult.success((Object)direction) : DataResult.error((String)"Expected a vertical direction");
    }

    public static Collection<Direction> allShuffled(Random random) {
        return DirectionUtils.shuffledCopy(Direction.values(), random);
    }

    public static Stream<Direction> stream() {
        return Stream.of(Direction.values());
    }

    public static <T> List<T> toShuffledList(Stream<T> stream, Random random) {
        ObjectArrayList list = stream.collect(Collector.of(ObjectArrayList::new, ObjectArrayList::add, (source, target) -> {
            source.addAll((Collection)target);
            return source;
        }, new Collector.Characteristics[0]));
        DirectionUtils.shuffle(list, random);
        return list;
    }

    private static <T> List<T> shuffledCopy(T[] objects, Random random) {
        ObjectArrayList list = new ObjectArrayList((Object[])objects);
        DirectionUtils.shuffle(list, random);
        return list;
    }

    public static <T> List<T> shuffledCopy(ObjectArrayList<T> list, Random random) {
        ObjectArrayList newList = new ObjectArrayList(list);
        DirectionUtils.shuffle(newList, random);
        return newList;
    }

    private static <T> void shuffle(ObjectArrayList<T> list, Random random) {
        int size;
        for (int i = size = list.size(); i > 1; --i) {
            int index = random.nextInt(i);
            list.set(i - 1, list.set(index, list.get(i - 1)));
        }
    }

    public static Direction getFacingAxis(Entity entity, Direction.Axis axis) {
        switch (axis) {
            case X: {
                return Direction.EAST.func_243532_a(entity.func_195046_g(1.0f)) ? Direction.EAST : Direction.WEST;
            }
            case Z: {
                return Direction.SOUTH.func_243532_a(entity.func_195046_g(1.0f)) ? Direction.SOUTH : Direction.NORTH;
            }
        }
        return entity.func_195050_f(1.0f) < 0.0f ? Direction.UP : Direction.DOWN;
    }
}

