/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.core.util;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import net.minecraft.world.gen.carver.ConfiguredCarver;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.StructureFeature;

public final class ExtraCodecs {
    public static final Codec<Integer> POSITIVE_INT = ExtraCodecs.intRangeWithMessage(1, Integer.MAX_VALUE, integer -> "Value must be positive: " + integer);
    public static final Codec<Float> POSITIVE_FLOAT = ExtraCodecs.floatRangeMinExclusiveWithMessage(0.0f, Float.MAX_VALUE, float_ -> "Value must be positive: " + float_);

    public static <F, S> Codec<Either<F, S>> xor(Codec<F> first, Codec<S> second) {
        return new XorCodec<F, S>(first, second);
    }

    public static <T> Codec<T> validate(Codec<T> codec, Function<T, DataResult<T>> function) {
        return codec.flatXmap(function, function);
    }

    public static <T> Function<List<T>, DataResult<List<T>>> nonEmptyListCheck() {
        return list -> list.isEmpty() ? DataResult.error((String)"List must have contents") : DataResult.success((Object)list);
    }

    public static <T> Codec<List<T>> nonEmptyList(Codec<List<T>> codec) {
        return codec.flatXmap(ExtraCodecs.nonEmptyListCheck(), ExtraCodecs.nonEmptyListCheck());
    }

    private static <N extends Number> Function<N, DataResult<N>> checkRangeWithMessage(N min, N max, Function<N, String> errorMessage) {
        return value -> ((Comparable)((Object)value)).compareTo(min) >= 0 && ((Comparable)((Object)value)).compareTo(max) <= 0 ? DataResult.success((Object)value) : DataResult.error((String)((String)errorMessage.apply(value)));
    }

    private static Codec<Integer> intRangeWithMessage(int min, int max, Function<Integer, String> errorMessage) {
        Function<Integer, DataResult<Integer>> function = ExtraCodecs.checkRangeWithMessage(min, max, errorMessage);
        return Codec.INT.flatXmap(function, function);
    }

    private static <N extends Number> Function<N, DataResult<N>> checkRangeMinExclusiveWithMessage(N min, N max, Function<N, String> errorMessage) {
        return value -> ((Comparable)((Object)value)).compareTo(min) > 0 && ((Comparable)((Object)value)).compareTo(max) <= 0 ? DataResult.success((Object)value) : DataResult.error((String)((String)errorMessage.apply(value)));
    }

    private static Codec<Float> floatRangeMinExclusiveWithMessage(float min, float max, Function<Float, String> errorMessage) {
        Function<Float, DataResult<Float>> function = ExtraCodecs.checkRangeMinExclusiveWithMessage(Float.valueOf(min), Float.valueOf(max), errorMessage);
        return Codec.FLOAT.flatXmap(function, function);
    }

    public static boolean serializeAndCompareFeature(ConfiguredFeature<?, ?> first, ConfiguredFeature<?, ?> second) {
        if (first == second) {
            return true;
        }
        Optional<JsonElement> firstElement = WorldGenCodecs.encodeFeature(first);
        if (!firstElement.isPresent()) {
            return false;
        }
        Optional<JsonElement> secondElement = WorldGenCodecs.encodeFeature(second);
        if (!secondElement.isPresent()) {
            return false;
        }
        JsonElement firstJson = firstElement.get();
        JsonElement secondJson = secondElement.get();
        return firstJson.equals(secondJson);
    }

    public static boolean serializeAndCompareStructure(StructureFeature<?, ?> first, StructureFeature<?, ?> second) {
        if (first == second) {
            return true;
        }
        Optional<JsonElement> firstElement = WorldGenCodecs.encodeStructure(first);
        if (!firstElement.isPresent()) {
            return false;
        }
        Optional<JsonElement> secondElement = WorldGenCodecs.encodeStructure(second);
        if (!secondElement.isPresent()) {
            return false;
        }
        JsonElement firstJson = firstElement.get();
        JsonElement secondJson = secondElement.get();
        return firstJson.equals(secondJson);
    }

    public static boolean serializeAndCompareCarver(ConfiguredCarver<?> first, ConfiguredCarver<?> second) {
        if (first == second) {
            return true;
        }
        Optional<JsonElement> firstElement = WorldGenCodecs.encodeCarver(first);
        if (!firstElement.isPresent()) {
            return false;
        }
        Optional<JsonElement> secondElement = WorldGenCodecs.encodeCarver(second);
        if (!secondElement.isPresent()) {
            return false;
        }
        JsonElement firstJson = firstElement.get();
        JsonElement secondJson = secondElement.get();
        return firstJson.equals(secondJson);
    }

    static final class XorCodec<F, S>
    implements Codec<Either<F, S>> {
        private final Codec<F> first;
        private final Codec<S> second;

        public XorCodec(Codec<F> first, Codec<S> second) {
            this.first = first;
            this.second = second;
        }

        public <T> DataResult<Pair<Either<F, S>, T>> decode(DynamicOps<T> ops, T value) {
            DataResult firstData = this.first.decode(ops, value).map(pair -> pair.mapFirst(Either::left));
            DataResult secondData = this.second.decode(ops, value).map(pair -> pair.mapFirst(Either::right));
            Optional firstResult = firstData.result();
            Optional secondResult = secondData.result();
            if (firstResult.isPresent() && secondResult.isPresent()) {
                return DataResult.error((String)("Both alternatives read successfully, can not pick the correct one; first: " + firstResult.get() + " second: " + secondResult.get()), (Object)((Pair)firstResult.get()));
            }
            return firstResult.isPresent() ? firstData : secondData;
        }

        public <T> DataResult<T> encode(Either<F, S> either, DynamicOps<T> ops, T value) {
            return (DataResult)either.map(entry -> this.first.encode(entry, ops, value), entry -> this.second.encode(entry, ops, value));
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object != null && this.getClass() == object.getClass()) {
                XorCodec codec = (XorCodec)object;
                return Objects.equals(this.first, codec.first) && Objects.equals(this.second, codec.second);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.first, this.second);
        }

        public String toString() {
            return "XorCodec[" + this.first + ", " + this.second + "]";
        }
    }

    public static final class WorldGenCodecs {
        public static final CodecCache<ConfiguredFeature<?, ?>> CONFIGURED_FEATURE_CODEC_CACHE = CodecCache.of(ConfiguredFeature.field_242763_a);
        public static final CodecCache<StructureFeature<?, ?>> CONFIGURED_STRUCTURE_CODEC_CACHE = CodecCache.of(StructureFeature.field_236267_a_);
        public static final CodecCache<ConfiguredCarver<?>> CONFIGURED_CARVER_CODEC_CACHE = CodecCache.of(ConfiguredCarver.field_236235_a_);

        public static Optional<JsonElement> encodeFeature(ConfiguredFeature<?, ?> feature) {
            return CONFIGURED_FEATURE_CODEC_CACHE.get(feature);
        }

        public static Optional<JsonElement> encodeStructure(StructureFeature<?, ?> structure) {
            return CONFIGURED_STRUCTURE_CODEC_CACHE.get(structure);
        }

        public static Optional<JsonElement> encodeCarver(ConfiguredCarver<?> carver) {
            return CONFIGURED_CARVER_CODEC_CACHE.get(carver);
        }
    }

    public static final class CodecCache<T> {
        public static final int DEFAULT_CACHE_SIZE = 4096;
        private final Codec<T> codec;
        private final Map<T, Optional<JsonElement>> cache;
        private final AtomicInteger requestCount = new AtomicInteger(0);

        private CodecCache(Codec<T> codec, Map<T, Optional<JsonElement>> backing) {
            this.codec = codec;
            this.cache = backing;
        }

        public void clear() {
            this.cache.clear();
            this.requestCount.set(0);
        }

        public Optional<JsonElement> get(T value) {
            this.requestCount.incrementAndGet();
            return this.cache.computeIfAbsent(value, this::encode);
        }

        public String getStats() {
            int size = this.cache.size();
            int requests = this.requestCount.get();
            return String.format("Size: %s, Requests: %s, Hits: %s", size, requests, requests - size);
        }

        private Optional<JsonElement> encode(T value) {
            return this.codec.encodeStart((DynamicOps)JsonOps.INSTANCE, value).result();
        }

        public static <T> CodecCache<T> of(Codec<T> codec) {
            return new CodecCache<T>(codec, new IdentityHashMap(4096));
        }

        public static <T> CodecCache<T> concurrent(Codec<T> codec) {
            return new CodecCache<T>(codec, new ConcurrentHashMap(4096));
        }
    }
}

