/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.core.util;

import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IObjectIntIterable;
import org.jetbrains.annotations.Nullable;

public class FriendlyByteBufUtils {
    public static <T> void writeId(PacketBuffer buf, IObjectIntIterable<T> map, T value) {
        int i = map.func_148757_b(value);
        if (i == -1) {
            throw new IllegalArgumentException("Can't find id for '" + value + "' in map " + map);
        }
        buf.func_150787_b(i);
    }

    @Nullable
    public static <T> T readById(PacketBuffer buf, IObjectIntIterable<T> map) {
        return (T)map.func_148745_a(buf.func_150792_a());
    }

    public static <T> void writeOptional(PacketBuffer buf, Optional<T> optional, Writer<T> writer) {
        if (optional.isPresent()) {
            buf.writeBoolean(true);
            writer.accept(buf, optional.get());
        } else {
            buf.writeBoolean(false);
        }
    }

    public static <T> Optional<T> readOptional(PacketBuffer buf, Reader<T> reader) {
        return buf.readBoolean() ? Optional.of(reader.apply(buf)) : Optional.empty();
    }

    public static interface Writer<T>
    extends BiConsumer<PacketBuffer, T> {
        default public Writer<Optional<T>> asOptional() {
            return (buf, optional) -> FriendlyByteBufUtils.writeOptional(buf, optional, this);
        }
    }

    public static interface Reader<T>
    extends Function<PacketBuffer, T> {
        default public Reader<Optional<T>> asOptional() {
            return buf -> FriendlyByteBufUtils.readOptional(buf, this);
        }
    }
}

