/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.core.util;

import java.util.Random;
import net.minecraft.util.math.MathHelper;

public final class MathUtils {
    public static double clampedMap(double value, double prevStart, double prevEnd, double start, double end) {
        return MathHelper.func_151238_b((double)start, (double)end, (double)MathHelper.func_233020_c_((double)value, (double)prevStart, (double)prevEnd));
    }

    public static float clampedMap(float value, float prevStart, float prevEnd, float start, float end) {
        return MathUtils.clampedLerp(start, end, MathUtils.inverseLerp(value, prevStart, prevEnd));
    }

    public static float clampedLerp(float start, float end, float delta) {
        if (delta < 0.0f) {
            return start;
        }
        return delta > 1.0f ? end : MathHelper.func_219799_g((float)delta, (float)start, (float)end);
    }

    public static float inverseLerp(float value, float start, float end) {
        return (value - start) / (end - start);
    }

    public static int randomBetweenInclusive(Random random, int min, int max) {
        return random.nextInt(max - min + 1) + min;
    }

    public static float randomBetween(Random random, float min, float max) {
        return random.nextFloat() * (max - min) + min;
    }

    public static float normal(Random random, float mean, float deviation) {
        return mean + (float)random.nextGaussian() * deviation;
    }

    public static double map(double value, double prevStart, double prevEnd, double start, double end) {
        return MathHelper.func_219803_d((double)MathHelper.func_233020_c_((double)value, (double)prevStart, (double)prevEnd), (double)start, (double)end);
    }

    public static float catmullrom(float delta, float startPoint, float start, float end, float endPoint) {
        return 0.5f * (2.0f * start + (end - startPoint) * delta + (2.0f * startPoint - 5.0f * start + 4.0f * end - endPoint) * delta * delta + (3.0f * start - startPoint - 3.0f * end + endPoint) * delta * delta * delta);
    }
}

