/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.core.util;

import com.blackgear.platform.core.util.MathUtils;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.world.gen.MaxMinNoiseMixer;
import net.minecraft.world.gen.OctavesNoiseGenerator;

public final class NoiseUtils {
    public static MaxMinNoiseMixer normal(SharedSeedRandom random, int amplitudes, double ... octaves) {
        return MaxMinNoiseMixer.func_242930_a((SharedSeedRandom)random, (int)amplitudes, (DoubleList)new DoubleArrayList(octaves));
    }

    public static MaxMinNoiseMixer normal(long seed, int amplitudes, double ... octaves) {
        return MaxMinNoiseMixer.func_242930_a((SharedSeedRandom)new SharedSeedRandom(seed), (int)amplitudes, (DoubleList)new DoubleArrayList(octaves));
    }

    public static OctavesNoiseGenerator perlin(SharedSeedRandom random, int amplitudes, double ... octaves) {
        return OctavesNoiseGenerator.func_242932_a((SharedSeedRandom)random, (int)amplitudes, (DoubleList)new DoubleArrayList(octaves));
    }

    public static OctavesNoiseGenerator perlin(long seed, int amplitudes, double ... octaves) {
        return OctavesNoiseGenerator.func_242932_a((SharedSeedRandom)new SharedSeedRandom(seed), (int)amplitudes, (DoubleList)new DoubleArrayList(octaves));
    }

    public static double sampleNoiseAndMapToRange(MaxMinNoiseMixer noise, double x, double y, double z, double start, double end) {
        double value = noise.func_237211_a_(x, y, z);
        return MathUtils.map(value, -1.0, 1.0, start, end);
    }

    public static double biasTowardsExtreme(double value, double factor) {
        return value + Math.sin(Math.PI * value) * factor / Math.PI;
    }
}

